/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.swing;

import java.awt.Font;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultCaret;

public class LogPanel
extends JPanel {
    private final DefaultCaret mCaret;
    private JScrollPane scrollPane;
    private JTextArea textArea;

    public LogPanel() {
        this.initComponents();
        this.mCaret = (DefaultCaret)this.textArea.getCaret();
        this.mCaret.setUpdatePolicy(2);
    }

    public synchronized void clear() {
        this.textArea.setText("");
    }

    public String getText() {
        return this.textArea.getText();
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public synchronized void println(String string) {
        SwingUtilities.invokeLater(() -> this.textArea.append(string + "\n"));
    }

    public void scrollToBottom() {
        this.setCaretPosition(this.textArea.getText().length());
    }

    public void scrollToTop() {
        this.setCaretPosition(0);
    }

    private void setCaretPosition(int pos) {
        SwingUtilities.invokeLater(() -> this.textArea.setCaretPosition(pos));
    }

    public void setWordWrap(boolean value) {
        this.textArea.setWrapStyleWord(value);
        this.textArea.setLineWrap(value);
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setColumns(20);
        this.textArea.setFont(new Font("Monospaced", 0, 15));
        this.textArea.setLineWrap(true);
        this.textArea.setRows(5);
        this.textArea.setWrapStyleWord(true);
        this.scrollPane.setViewportView(this.textArea);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane));
    }
}

