/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.swing;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import se.trixon.almond.util.MailHelper;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.Xlog;

public class UriLabel
extends JLabel {
    private URI mUri;

    public UriLabel() {
        this.init();
    }

    public UriLabel(Icon icon) {
        super(icon);
        this.init();
    }

    public UriLabel(Icon icon, int horizontalAlignment) {
        super(icon, horizontalAlignment);
        this.init();
    }

    public UriLabel(String text) {
        super(text);
        this.init();
    }

    public UriLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.init();
    }

    public UriLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.init();
    }

    @Override
    public void setText(String text) {
        super.setText("<html><a href=\"\">%s</a></html>".formatted(text));
    }

    public void setUri(URI uri) {
        this.mUri = uri;
    }

    public void setUri(String uriString) {
        try {
            this.mUri = new URI(uriString);
        }
        catch (URISyntaxException ex) {
            System.err.println(ex);
        }
    }

    private void init() {
        this.setCursor(new Cursor(12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UriLabel.this.launchURI(evt);
            }
        });
    }

    private void launchURI(MouseEvent evt) {
        if (this.mUri != null && Desktop.isDesktopSupported()) {
            try {
                if (StringUtils.startsWith((CharSequence)this.mUri.getScheme(), (CharSequence)"http")) {
                    SystemHelper.desktopBrowse(this.mUri.toString());
                } else {
                    MailHelper.mail(this.mUri);
                }
            }
            catch (UnsupportedOperationException ex) {
                Xlog.e(this.getClass(), ex.getLocalizedMessage());
            }
        }
    }
}

