/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.swing.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.StringUtils;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.icons.material.swing.MaterialIcon;

public class FileChooserPanel
extends JPanel {
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private DropTarget mDropTarget;
    private final JFileChooser mFileChooser = new JFileChooser();
    private int mMode;
    private transient FileChooserButtonListener mFileChooserButtonListener;
    private String mTitle;
    private DropMode mDropMode = DropMode.SINGLE;
    private File[] mPaths;
    private static FileNameExtensionFilter mFilter;
    private JButton mButton;
    private JCheckBox mCheckBox;
    private JLabel mLabel;
    private JTextField mTextField;
    private JToolBar toolBar;

    public FileChooserPanel() {
        this.initComponents();
        this.init();
    }

    public void addFilter(FileNameExtensionFilter filter) {
        this.mFileChooser.addChoosableFileFilter(filter);
    }

    public void setFilter(FileNameExtensionFilter filter) {
        mFilter = filter;
        this.mFileChooser.setFileFilter(filter);
    }

    public void clearFilters() {
        this.mFileChooser.resetChoosableFileFilters();
    }

    public FileNameExtensionFilter getFilter() {
        return mFilter;
    }

    public FileChooserPanel(int mode, String title) {
        this.initComponents();
        this.init();
        this.mMode = mode;
        this.mTitle = title;
        this.mFileChooser.setFileSelectionMode(this.mMode);
    }

    public DropMode getDropMode() {
        return this.mDropMode;
    }

    public JFileChooser getFileChooser() {
        return this.mFileChooser;
    }

    public String getHeader() {
        return this.mLabel.getText();
    }

    public int getMode() {
        return this.mMode;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public boolean isSelected() {
        return this.mCheckBox.isSelected();
    }

    public void setDropMode(DropMode dropMode) {
        this.mDropMode = dropMode;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public void setButtonListener(FileChooserButtonListener fileChooserButtonListener) {
        this.mFileChooserButtonListener = fileChooserButtonListener;
    }

    public void setMode(int mode) {
        this.mMode = mode;
        this.mFileChooser.setFileSelectionMode(this.mMode);
    }

    public void setCheckBoxMode(boolean checkBoxMode) {
        this.mLabel.setVisible(!checkBoxMode);
        this.mCheckBox.setVisible(checkBoxMode);
    }

    public JButton getButton() {
        return this.mButton;
    }

    public File getFile() {
        File file = null;
        if (!StringUtils.isBlank((CharSequence)this.getPath())) {
            file = new File(this.getPath());
        }
        return file;
    }

    public JLabel getLabel() {
        return this.mLabel;
    }

    public String getPath() {
        return this.mTextField.getText();
    }

    public File[] getPaths() {
        return this.mPaths;
    }

    public JTextField getTextField() {
        return this.mTextField;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mLabel.setEnabled(enabled);
        this.mButton.setEnabled(enabled);
        this.mTextField.setEnabled(enabled);
        this.activateDropTarget(enabled);
    }

    public void setHeader(String string) {
        this.mLabel.setText(string);
        this.mCheckBox.setText(string);
    }

    public void setPath(String path) {
        this.mTextField.setText(path);
    }

    public void setSelected(boolean selected) {
        this.mCheckBox.setSelected(selected);
    }

    private void activateDropTarget(boolean activate) {
        if (activate) {
            this.mTextField.setDropTarget(this.mDropTarget);
        } else {
            this.mTextField.setDropTarget(null);
        }
    }

    private void init() {
        this.mButton.setIcon(MaterialIcon._File.FOLDER_OPEN.getImageIcon(22));
        this.mDropTarget = new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent evt) {
                try {
                    evt.acceptDrop(1);
                    LinkedList droppedFiles = new LinkedList((List)evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor));
                    LinkedList<File> invalidFiles = new LinkedList<File>();
                    for (File droppedFile : droppedFiles) {
                        if (droppedFile.isFile()) {
                            if (FileChooserPanel.this.mMode != 1) continue;
                            invalidFiles.add(droppedFile);
                            continue;
                        }
                        if (droppedFile.isDirectory()) {
                            if (FileChooserPanel.this.mMode != 0) continue;
                            invalidFiles.add(droppedFile);
                            continue;
                        }
                        invalidFiles.add(droppedFile);
                    }
                    for (File invalidFile : invalidFiles) {
                        droppedFiles.remove(invalidFile);
                    }
                    FileChooserPanel.this.mPaths = droppedFiles.toArray(new File[droppedFiles.size()]);
                    if (FileChooserPanel.this.mDropMode == DropMode.SINGLE) {
                        String path = "";
                        if (droppedFiles.size() > 0) {
                            path = ((File)droppedFiles.get(0)).getAbsolutePath();
                        }
                        FileChooserPanel.this.mTextField.setText(path);
                    } else {
                        StringBuilder sb = new StringBuilder();
                        for (File file : droppedFiles) {
                            sb.append(file.getAbsolutePath()).append(PATH_SEPARATOR);
                        }
                        sb.deleteCharAt(sb.length() - 1);
                        FileChooserPanel.this.mTextField.setText(sb.toString());
                    }
                    try {
                        FileChooserPanel.this.mFileChooserButtonListener.onFileChooserDrop(FileChooserPanel.this);
                    }
                    catch (Exception exception) {}
                }
                catch (UnsupportedFlavorException | IOException exception) {
                    // empty catch block
                }
            }
        };
        this.activateDropTarget(true);
        this.mCheckBox.setVisible(false);
    }

    private void initComponents() {
        this.mLabel = new JLabel();
        this.mCheckBox = new JCheckBox();
        this.mTextField = new JTextField();
        this.toolBar = new JToolBar();
        this.mButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.mLabel.setText(Dict.PATH.toString());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.mLabel, gridBagConstraints);
        this.mCheckBox.setText(Dict.PATH.toString());
        this.mCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileChooserPanel.this.mCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.mCheckBox, gridBagConstraints);
        this.mTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileChooserPanel.this.mTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.mTextField, gridBagConstraints);
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setBorderPainted(false);
        this.mButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileChooserPanel.this.mButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.mButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.toolBar, gridBagConstraints);
    }

    private void mButtonActionPerformed(ActionEvent evt) {
        File baseDirectory;
        try {
            this.mFileChooserButtonListener.onFileChooserPreSelect(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mTitle != null) {
            this.mFileChooser.setDialogTitle(this.mTitle);
        }
        if ((baseDirectory = new File(this.mTextField.getText())).exists() && baseDirectory.isFile()) {
            baseDirectory = baseDirectory.getParentFile();
        }
        this.mFileChooser.setCurrentDirectory(baseDirectory);
        int returnVal = this.mFileChooser.showOpenDialog(this.mButton.getTopLevelAncestor());
        if (returnVal == 0) {
            this.mPaths = this.mFileChooser.getSelectedFiles();
            if (!this.mFileChooser.isMultiSelectionEnabled()) {
                this.mTextField.setText(this.mFileChooser.getSelectedFile().toString());
            }
            try {
                this.mFileChooserButtonListener.onFileChooserOk(this, this.mFileChooser.getSelectedFile());
            }
            catch (Exception exception) {}
        } else {
            try {
                this.mFileChooserButtonListener.onFileChooserCancel(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void mTextFieldActionPerformed(ActionEvent evt) {
        File file = new File(this.mTextField.getText().trim());
        this.setPath(file.getAbsolutePath());
        if (file.exists() && file.isDirectory()) {
            try {
                this.mFileChooserButtonListener.onFileChooserOk(this, file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void mCheckBoxActionPerformed(ActionEvent evt) {
        this.setEnabled(this.mCheckBox.isSelected());
        try {
            this.mFileChooserButtonListener.onFileChooserCheckBoxChange(this, this.mCheckBox.isSelected());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static enum DropMode {
        MULTI,
        SINGLE;

    }

    public static interface FileChooserButtonListener {
        public void onFileChooserCancel(FileChooserPanel var1);

        public void onFileChooserCheckBoxChange(FileChooserPanel var1, boolean var2);

        public void onFileChooserDrop(FileChooserPanel var1);

        public void onFileChooserOk(FileChooserPanel var1, File var2);

        public void onFileChooserPreSelect(FileChooserPanel var1);
    }
}

