/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.swing.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import se.trixon.almond.util.AlmondOptions;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.swing.SwingHelper;

public class LookAndFeelPanel
extends JPanel {
    private final transient AlmondOptions mAlmondOptions = AlmondOptions.getInstance();
    private JLabel jLabel1;
    private JComboBox<String> lafComboBox;
    private JCheckBox lafForceCheckBox;
    private JLabel lafLabel;
    private JCheckBox menuIconsCheckBox;

    public LookAndFeelPanel() {
        this.initComponents();
        this.load();
    }

    public void save() {
        this.mAlmondOptions.setForceLookAndFeel(this.lafForceCheckBox.isSelected());
        this.mAlmondOptions.setLookAndFeel((String)this.lafComboBox.getSelectedItem());
        this.mAlmondOptions.setDisplayMenuIcons(this.menuIconsCheckBox.isSelected());
    }

    private void load() {
        this.lafForceCheckBox.setSelected(this.mAlmondOptions.isForceLookAndFeel());
        this.lafComboBox.setModel(SwingHelper.getLookAndFeelComboBoxModel(true));
        this.lafComboBox.setSelectedItem(this.mAlmondOptions.getLookAndFeel());
        this.lafForceCheckBoxActionPerformed(null);
        this.menuIconsCheckBox.setSelected(this.mAlmondOptions.isDisplayMenuIcons());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.lafForceCheckBox = new JCheckBox();
        this.lafLabel = new JLabel();
        this.lafComboBox = new JComboBox();
        this.menuIconsCheckBox = new JCheckBox();
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 2 | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setText(Dict.LOOK_AND_FEEL.toString());
        ResourceBundle bundle = ResourceBundle.getBundle("se/trixon/almond/util/swing/dialogs/Bundle");
        this.lafForceCheckBox.setText(bundle.getString("LookAndFeelPanel.lafForceCheckBox.text"));
        this.lafForceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LookAndFeelPanel.this.lafForceCheckBoxActionPerformed(evt);
            }
        });
        this.lafLabel.setText(Dict.THEME.toString());
        this.menuIconsCheckBox.setText(bundle.getString("LookAndFeelPanel.menuIconsCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lafComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.lafForceCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.menuIconsCheckBox, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.lafLabel)).addGap(0, 0, Short.MAX_VALUE))).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lafForceCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lafLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lafComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.menuIconsCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void lafForceCheckBoxActionPerformed(ActionEvent evt) {
        this.lafComboBox.setEnabled(this.lafForceCheckBox.isSelected());
        this.lafLabel.setEnabled(this.lafForceCheckBox.isSelected());
    }
}

