/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.swing.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import se.trixon.almond.util.Dict;

public class SimpleDialog {
    private static final HashMap<String, FileNameExtensionFilter> sExtensionFilters = new HashMap();
    private static final JFileChooser sFileChooser = new JFileChooser();
    private static FileNameExtensionFilter sFilter;
    private static Component sParent;
    private static File sPath;
    private static File[] sPaths;
    private static String sTitle;

    public static void addFilter(FileNameExtensionFilter filter) {
        sFileChooser.addChoosableFileFilter(filter);
    }

    public static void addFilters(FileNameExtensionFilter ... filters) {
        for (FileNameExtensionFilter filter : filters) {
            SimpleDialog.addFilter(filter);
        }
    }

    public static void addFilters(String ... filters) {
        for (String filter : filters) {
            SimpleDialog.addFilter(sExtensionFilters.get(filter));
        }
    }

    public static void clearFilters() {
        sFileChooser.resetChoosableFileFilters();
    }

    public static void clearSelection() {
        File currentDirectory = sFileChooser.getCurrentDirectory();
        sFileChooser.setSelectedFile(new File(""));
        sFileChooser.setSelectedFiles(new File[]{new File("")});
        sFileChooser.setCurrentDirectory(currentDirectory);
        sFileChooser.rescanCurrentDirectory();
    }

    public static HashMap<String, FileNameExtensionFilter> getExtensionFilters() {
        return sExtensionFilters;
    }

    public static FileNameExtensionFilter getFilter() {
        return sFilter;
    }

    public static Component getParent() {
        return sParent;
    }

    public static File getPath() {
        return sPath;
    }

    public static File[] getPaths() {
        return sPaths;
    }

    public static String getTitle() {
        return sTitle;
    }

    public static boolean openFile() {
        return SimpleDialog.openFile(false);
    }

    public static boolean openFile(boolean multiSelection) {
        sFileChooser.setFileSelectionMode(0);
        sFileChooser.setMultiSelectionEnabled(multiSelection);
        sPaths = new File[0];
        int result = sFileChooser.showOpenDialog(sParent);
        if (result == 0) {
            if (multiSelection) {
                sPaths = sFileChooser.getSelectedFiles();
            } else {
                sPath = sFileChooser.getSelectedFile();
            }
        }
        return result == 0;
    }

    public static boolean openFileAndDirectoy() {
        return SimpleDialog.openFileAndDirectoy(false);
    }

    public static boolean openFileAndDirectoy(boolean multiSelection) {
        sFileChooser.setFileSelectionMode(2);
        sFileChooser.setMultiSelectionEnabled(multiSelection);
        sPaths = new File[0];
        int result = sFileChooser.showOpenDialog(sParent);
        if (result == 0) {
            if (multiSelection) {
                sPaths = sFileChooser.getSelectedFiles();
            } else {
                sPath = sFileChooser.getSelectedFile();
            }
        }
        return result == 0;
    }

    @Deprecated
    public static boolean saveFile(String ... extensions) {
        return SimpleDialog.saveFile();
    }

    public static boolean saveFile() {
        int result;
        if (sFileChooser.showSaveDialog(sParent) != 0) {
            return false;
        }
        File file = sFileChooser.getSelectedFile();
        if (!sFileChooser.getFileFilter().accept(file)) {
            FileNameExtensionFilter fileNameExtensionFilter = (FileNameExtensionFilter)sFileChooser.getFileFilter();
            String[] extensions = fileNameExtensionFilter.getExtensions();
            Object suffix = file.getName().endsWith(".") ? extensions[0] : "." + extensions[0];
            file = new File(file.getAbsolutePath() + (String)suffix);
        }
        if (file.exists() && (result = JOptionPane.showConfirmDialog(sParent, Dict.Dialog.MESSAGE_FILE_EXISTS.toString().formatted(file.getAbsolutePath()), Dict.Dialog.TITLE_FILE_EXISTS.toString(), 0)) == 1) {
            return SimpleDialog.saveFile();
        }
        sPath = file;
        return true;
    }

    public static Color selectColor(Color color) {
        Color newColor = JColorChooser.showDialog(sParent, Dict.SELECT_COLOR.toString(), color);
        return newColor;
    }

    public static boolean selectDirectory() {
        sFileChooser.setFileSelectionMode(1);
        int result = sFileChooser.showOpenDialog(sParent);
        if (result == 0) {
            sPath = sFileChooser.getSelectedFile();
        }
        return result == 0;
    }

    public static void selectFont() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void setFilter(FileNameExtensionFilter filter) {
        sFilter = filter;
        sFileChooser.setFileFilter(filter);
    }

    public static void setFilter(String filterExt) {
        SimpleDialog.setFilter(sExtensionFilters.get(filterExt));
    }

    public static void setParent(Component parent) {
        sParent = parent;
    }

    public static void setPath(File path) {
        sPath = path;
        sFileChooser.setCurrentDirectory(sPath);
    }

    public static void setSelectedFile(File file) {
        sFileChooser.setSelectedFile(file);
    }

    public static void setTitle(String title) {
        sTitle = title;
        sFileChooser.setDialogTitle(sTitle);
    }

    public static void showHidden(boolean showHidden) {
        sFileChooser.setFileHidingEnabled(!showHidden);
    }

    private SimpleDialog() {
    }

    static {
        sPaths = new File[0];
    }
}

