/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.swing.dialogs.about;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import se.trixon.almond.util.AboutModel;
import se.trixon.almond.util.AlmondAction;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.Scaler;
import se.trixon.almond.util.swing.SwingHelper;
import se.trixon.almond.util.swing.dialogs.about.AboutTab;
import se.trixon.almond.util.swing.dialogs.about.AuthorsTab;
import se.trixon.almond.util.swing.dialogs.about.LibrariesTab;
import se.trixon.almond.util.swing.dialogs.about.PropertiesTab;
import se.trixon.almond.util.swing.dialogs.about.ThanksToTab;
import se.trixon.almond.util.swing.dialogs.about.TranslationTab;

public class AboutPanel
extends JPanel {
    private transient AboutModel mAboutModel;
    private static String sAppName;
    private final HashSet<TabComponentListener> mTabComponentListeners = new HashSet();
    private JLabel appDateLabel;
    private JLabel appNameLabel;
    private JLabel appVersionLabel;
    private JLabel iconLabel;
    private JPanel panel;
    private JTabbedPane tabbedPane;

    public static AlmondAction getAction(final Component parentComponent, final AboutPanel aboutPanel) {
        AlmondAction action = new AlmondAction(Dict.ABOUT.toString()){

            @Override
            public void actionPerformed(ActionEvent e) {
                aboutPanel.reset();
                SwingHelper.makeWindowResizable(aboutPanel);
                Object[] options = new Object[]{Dict.CLOSE.toString()};
                JOptionPane.showOptionDialog(parentComponent, aboutPanel, Dict.ABOUT_S.toString().formatted(sAppName), -1, -1, null, options, options[0]);
            }
        };
        return action;
    }

    public AboutPanel() {
        this.initComponents();
        this.init();
    }

    public AboutPanel(AboutModel aboutModel) {
        this.initComponents();
        this.mAboutModel = aboutModel;
        this.init();
        this.setPreferredSize(SwingHelper.getUIScaledDim(700, 400));
    }

    private void addLastComponent() {
        this.mTabComponentListeners.add((TabComponentListener)((Object)this.tabbedPane.getComponentAt(this.tabbedPane.getTabCount() - 1)));
    }

    private void init() {
        if (this.mAboutModel.getLogo() != null) {
            this.populateIcon((ImageIcon)this.mAboutModel.getLogo());
        }
        this.appNameLabel.setText(this.mAboutModel.getAppName());
        sAppName = this.mAboutModel.getAppName();
        this.appVersionLabel.setText("%s %s".formatted(Dict.VERSION.toString(), this.mAboutModel.getAppVersion()));
        this.appDateLabel.setText(this.mAboutModel.getAppDate());
        this.tabbedPane.add((Component)new AboutTab(this.mAboutModel), Dict.ABOUT.toString());
        this.tabbedPane.add((Component)new LibrariesTab(this.mAboutModel), Dict.LIBRARIES.toString());
        this.addLastComponent();
        if (this.mAboutModel.getAuthors() != null) {
            this.tabbedPane.add((Component)new AuthorsTab(this.mAboutModel), Dict.AUTHORS.toString());
            this.addLastComponent();
        }
        if (this.mAboutModel.getTranslation() != null) {
            this.tabbedPane.add((Component)new TranslationTab(this.mAboutModel), Dict.TRANSLATION.toString());
            this.addLastComponent();
        }
        if (this.mAboutModel.getThanksTo() != null) {
            this.tabbedPane.add((Component)new ThanksToTab(this.mAboutModel), Dict.THANKS_TO.toString());
            this.addLastComponent();
        }
        this.tabbedPane.add((Component)new PropertiesTab(), Dict.PROPERTIES.toString());
        this.addLastComponent();
    }

    private void populateIcon(ImageIcon imageIcon) {
        Scaler scaler = new Scaler(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        int maxSize = SwingHelper.getUIScaled(100);
        scaler.setHeight(maxSize);
        scaler.setWidth(maxSize);
        Image image = imageIcon.getImage().getScaledInstance(scaler.getDimension().width, scaler.getDimension().height, 4);
        this.iconLabel.setIcon(new ImageIcon(image));
    }

    private void reset() {
        this.tabbedPane.setSelectedIndex(0);
        this.mTabComponentListeners.forEach(listbox -> listbox.reset());
    }

    private void initComponents() {
        this.iconLabel = new JLabel();
        this.panel = new JPanel();
        this.appNameLabel = new JLabel();
        this.appVersionLabel = new JLabel();
        this.appDateLabel = new JLabel();
        this.tabbedPane = new JTabbedPane();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 16);
        this.add((Component)this.iconLabel, gridBagConstraints);
        this.appNameLabel.setFont(this.appNameLabel.getFont().deriveFont(this.appNameLabel.getFont().getStyle() | 1, this.appNameLabel.getFont().getSize() + 8));
        this.appNameLabel.setText("NAME");
        this.appVersionLabel.setFont(this.appVersionLabel.getFont().deriveFont((float)this.appVersionLabel.getFont().getSize() + 2.0f));
        this.appVersionLabel.setText("VERSION");
        this.appDateLabel.setFont(this.appDateLabel.getFont().deriveFont((float)this.appDateLabel.getFont().getSize() + 2.0f));
        this.appDateLabel.setText("DATE");
        GroupLayout panelLayout = new GroupLayout(this.panel);
        this.panel.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.appNameLabel, -1, -1, Short.MAX_VALUE).addGroup(panelLayout.createSequentialGroup().addComponent(this.appDateLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.appVersionLabel, -1, 392, Short.MAX_VALUE));
        panelLayout.setVerticalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayout.createSequentialGroup().addComponent(this.appNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.appVersionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.appDateLabel).addGap(0, 0, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.panel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(16, 0, 0, 0);
        this.add((Component)this.tabbedPane, gridBagConstraints);
    }

    public static interface TabComponentListener {
        public void reset();
    }
}

