/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.swing.dialogs.about;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import se.trixon.almond.util.AboutModel;
import se.trixon.almond.util.swing.dialogs.about.BaseListTab;

public class LibrariesTab
extends BaseListTab {
    private final transient AboutModel mAboutModel;
    private final ArrayList<String> mLibraries = new ArrayList();

    public LibrariesTab(AboutModel aboutModel) {
        this.mAboutModel = aboutModel;
        this.init();
    }

    private void init() {
        String javaVersion = System.getProperty("java.runtime.version");
        String javaName = System.getProperty("java.runtime.name");
        String java = "%s %s".formatted(javaName, javaVersion);
        this.mLibraries.add(java);
        ArrayList<String> libraries = new ArrayList<String>();
        libraries.add("Almond-Util");
        if (this.mAboutModel.getLibraries() != null) {
            String[] libs = StringUtils.split((String)this.mAboutModel.getLibraries(), (String)";");
            libraries.addAll(Arrays.asList(libs));
        }
        libraries.sort((o1, o2) -> o1.compareToIgnoreCase((String)o2));
        this.mLibraries.addAll(libraries);
        StringBuilder builder = new StringBuilder();
        this.mLibraries.forEach(library -> builder.append("\u25cf ").append((String)library).append("\n"));
        this.editorPane.setText(builder.toString());
        this.reset();
    }
}

