/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.swing.dialogs.cron;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.icons.material.swing.MaterialIcon;
import se.trixon.almond.util.swing.SwingHelper;
import se.trixon.almond.util.swing.dialogs.Message;
import se.trixon.almond.util.swing.dialogs.cron.CronPanel;

public class CronListPanel
extends JPanel {
    private static final int ICON_SIZE = 24;
    private DefaultListModel<String> mModel = new DefaultListModel();
    private static final String CRON_ITEM_SEPARATOR = "|";
    private final transient ResourceBundle mBundle = SystemHelper.getBundle(CronListPanel.class, "Bundle");
    protected JButton addButton;
    protected JCheckBox checkBox;
    protected JButton editButton;
    protected JList<String> list;
    protected JButton removeAllButton;
    protected JButton removeButton;
    protected JScrollPane scrollPane;
    protected JToolBar toolBar;

    public CronListPanel() {
        this.initComponents();
        this.init();
    }

    public DefaultListModel<String> getModel() {
        return this.mModel;
    }

    public String getSelectedCronString() {
        return this.list.getSelectedValue();
    }

    public boolean isActive() {
        return this.checkBox.isSelected();
    }

    public void setActive(boolean value) {
        this.checkBox.setSelected(value);
        this.list.setEnabled(this.checkBox.isSelected());
    }

    public String getCronItems() {
        return StringUtils.join((Object[])this.getModel().toArray(), (String)CRON_ITEM_SEPARATOR);
    }

    public void setCronItems(String cronItems) {
        for (String item : StringUtils.split((String)cronItems, (String)CRON_ITEM_SEPARATOR)) {
            this.getModel().addElement(item);
        }
    }

    public void setModel(DefaultListModel<String> model) {
        this.mModel = model;
        this.list.setModel(model);
    }

    public void sortModel() {
        Object[] objects = this.mModel.toArray();
        Arrays.sort(objects);
        this.mModel.clear();
        for (Object object : objects) {
            this.mModel.addElement((String)object);
        }
    }

    private Component getRoot() {
        return SwingUtilities.getRoot(this);
    }

    private void edit(String cronString) {
        boolean add = cronString == null;
        String title = cronString == null ? Dict.ADD.toString() : Dict.EDIT.toString();
        CronPanel cronPanel = new CronPanel();
        cronPanel.setCronString(cronString);
        SwingHelper.makeWindowResizable(cronPanel);
        int retval = JOptionPane.showOptionDialog(this.getRoot(), cronPanel, title, 2, -1, null, null, null);
        if (retval == 0) {
            String modifiedCronString = cronPanel.getCronString();
            if (cronPanel.isCronValid()) {
                if (add) {
                    this.getModel().addElement(modifiedCronString);
                } else {
                    this.getModel().set(this.getModel().indexOf(this.getSelectedCronString()), modifiedCronString);
                }
                this.sortModel();
                this.list.setSelectedValue(modifiedCronString, true);
            } else {
                Message.error(this, "Invalid cron string", modifiedCronString);
                this.edit(modifiedCronString);
            }
        }
    }

    private void init() {
        this.addButton.setIcon(MaterialIcon._Content.ADD.getImageIcon(24));
        this.editButton.setIcon(MaterialIcon._Editor.MODE_EDIT.getImageIcon(24));
        this.removeButton.setIcon(MaterialIcon._Content.REMOVE.getImageIcon(24));
        this.removeAllButton.setIcon(MaterialIcon._Content.CLEAR.getImageIcon(24));
        this.setModel(this.getModel());
        this.list.setSelectedIndex(0);
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.removeAllButton = new JButton();
        this.checkBox = new JCheckBox();
        this.scrollPane = new JScrollPane();
        this.list = new JList();
        this.setLayout(new BorderLayout());
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.addButton.setToolTipText(Dict.ADD.toString());
        this.addButton.setFocusable(false);
        this.addButton.setHorizontalTextPosition(0);
        this.addButton.setVerticalTextPosition(3);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CronListPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.addButton);
        this.editButton.setToolTipText(Dict.EDIT.toString());
        this.editButton.setFocusable(false);
        this.editButton.setHorizontalTextPosition(0);
        this.editButton.setVerticalTextPosition(3);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CronListPanel.this.editButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.editButton);
        this.removeButton.setToolTipText(Dict.REMOVE.toString());
        this.removeButton.setFocusable(false);
        this.removeButton.setHorizontalTextPosition(0);
        this.removeButton.setVerticalTextPosition(3);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CronListPanel.this.removeButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.removeButton);
        this.removeAllButton.setToolTipText(Dict.REMOVE_ALL.toString());
        this.removeAllButton.setFocusable(false);
        this.removeAllButton.setHorizontalTextPosition(0);
        this.removeAllButton.setVerticalTextPosition(3);
        this.removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CronListPanel.this.removeAllButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.removeAllButton);
        this.checkBox.setText(Dict.ACTIVE.toString());
        this.checkBox.setFocusable(false);
        this.checkBox.setHorizontalTextPosition(4);
        this.checkBox.setVerticalTextPosition(3);
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CronListPanel.this.checkBoxActionPerformed(evt);
            }
        });
        this.toolBar.add(this.checkBox);
        this.add((Component)this.toolBar, "First");
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CronListPanel.this.listMouseClicked(evt);
            }
        });
        this.scrollPane.setViewportView(this.list);
        this.add((Component)this.scrollPane, "Center");
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        if (this.isActive()) {
            this.edit(null);
        }
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        if (this.getSelectedCronString() != null && this.isActive()) {
            this.edit(this.getSelectedCronString());
        }
    }

    private void listMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2 && this.isActive()) {
            this.editButtonActionPerformed(null);
        }
    }

    private void removeAllButtonActionPerformed(ActionEvent evt) {
        int retval;
        if (!this.getModel().isEmpty() && (retval = JOptionPane.showConfirmDialog(this.getRoot(), this.mBundle.getString("CronPanel.message.removeAll"), this.mBundle.getString("CronPanel.title.removeAll"), 2, 2)) == 0) {
            this.getModel().removeAllElements();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        if (this.getSelectedCronString() != null && this.isActive()) {
            String message = this.mBundle.getString("CronPanel.message.remove").formatted(this.getSelectedCronString());
            int retval = JOptionPane.showConfirmDialog(this.getRoot(), message, this.mBundle.getString("CronPanel.title.remove"), 2, 2);
            if (retval == 0) {
                this.getModel().removeElement(this.getSelectedCronString());
            }
        }
    }

    private void checkBoxActionPerformed(ActionEvent evt) {
        this.list.setEnabled(this.checkBox.isSelected());
    }
}

