/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.swing.dialogs.cron;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import se.trixon.almond.util.ArrayHelper;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.StringHelper;
import se.trixon.almond.util.swing.dialogs.cron.CronExprChangeListener;

public abstract class ElementPanel
extends JPanel {
    protected final DefaultListModel<String> mListModel = new DefaultListModel();
    protected final ArrayList<String> mArray = new ArrayList();
    private int mOffset = 0;
    private transient CronExprChangeListener mCronExprChangeListener;
    private boolean mHasLast;
    private JRadioButton allRadioButton;
    private ButtonGroup buttonGroup;
    private JCheckBox checkBox;
    private JLabel label;
    private JList<String> list;
    private JScrollPane scrollPane;
    private JRadioButton selectedRadioButton;
    private JSpinner spinner;

    public ElementPanel() {
        this.initComponents();
        this.list.addListSelectionListener(e -> this.exprChanged());
        this.spinner.addChangeListener(e -> this.exprChanged());
    }

    public String getCronString() {
        StringBuilder stringBuilder = new StringBuilder();
        int[] indices = null;
        if (this.allRadioButton.isSelected()) {
            stringBuilder.append("*");
        } else {
            indices = ArrayHelper.adjustOffset(this.list.getSelectedIndices(), this.mOffset);
            stringBuilder.append(StringHelper.arrayToIntervalString(indices));
        }
        if (this.checkBox.isSelected()) {
            stringBuilder.append("/").append(this.spinner.getValue());
        }
        String cronString = stringBuilder.toString();
        if (this.selectedRadioButton.isSelected() && this.mHasLast) {
            String lastIndex = String.valueOf(this.mListModel.getSize());
            cronString = cronString.replace(lastIndex, "L");
        }
        return cronString;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public void setCronExprChangeListener(CronExprChangeListener cronExprChangeListener) {
        this.mCronExprChangeListener = cronExprChangeListener;
    }

    public void setHasLast(boolean hasLast) {
        this.mHasLast = hasLast;
    }

    public void setOffset(int offset) {
        this.mOffset = offset;
    }

    public void setCronString(String cronString) {
        boolean hasLast = cronString.contains("L");
        if (hasLast) {
            cronString = cronString.replace(",L", "").replace("L", "");
        }
        String[] every = StringUtils.split((String)cronString, (String)"/");
        String ab = every[0];
        String c = null;
        if (every.length == 2) {
            c = every[1];
            this.spinner.setValue(Integer.valueOf(c));
        }
        this.checkBox.setSelected(c != null);
        this.spinner.setEnabled(c != null);
        if (ab.contains("*")) {
            this.allRadioButton.doClick();
        } else {
            this.selectedRadioButton.doClick();
            String[] selections = StringHelper.intervalStringToArray(ab);
            int[] indices = ArrayHelper.stringToInt(selections);
            indices = ArrayHelper.adjustOffset(indices, -1 * this.mOffset);
            if (hasLast) {
                indices = ArrayUtils.add((int[])indices, (int)(this.mListModel.getSize() - 1));
            }
            this.list.setSelectedIndices(indices);
        }
    }

    public JList getList() {
        return this.list;
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    protected void initModel(ArrayList<String> arrayList) {
        arrayList.stream().forEach(string -> this.mListModel.addElement((String)string));
        this.list.setModel(this.mListModel);
        this.spinner.setModel(new SpinnerNumberModel(2, 2, this.mListModel.getSize() + this.mOffset - 1, 1));
    }

    private void exprChanged() {
        this.mCronExprChangeListener.onCronExprChanged();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.label = new JLabel();
        this.scrollPane = new JScrollPane();
        this.list = new JList();
        this.allRadioButton = new JRadioButton();
        this.selectedRadioButton = new JRadioButton();
        this.checkBox = new JCheckBox();
        this.spinner = new JSpinner();
        this.setPreferredSize(new Dimension(150, 300));
        this.label.setText("Label");
        this.list.setEnabled(false);
        this.scrollPane.setViewportView(this.list);
        this.buttonGroup.add(this.allRadioButton);
        this.allRadioButton.setSelected(true);
        this.allRadioButton.setText(Dict.ALL.toString());
        this.allRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ElementPanel.this.allRadioButtonActionPerformed(evt);
            }
        });
        this.buttonGroup.add(this.selectedRadioButton);
        this.selectedRadioButton.setText(Dict.SELECTED.toString());
        this.selectedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ElementPanel.this.selectedRadioButtonActionPerformed(evt);
            }
        });
        this.checkBox.setText(Dict.EVERY.toString());
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ElementPanel.this.checkBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane).addComponent(this.allRadioButton, -1, -1, Short.MAX_VALUE).addComponent(this.selectedRadioButton, -1, 138, Short.MAX_VALUE).addComponent(this.checkBox, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.label).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.spinner)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectedRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinner, -2, 28, -2).addContainerGap()));
    }

    private void selectedRadioButtonActionPerformed(ActionEvent evt) {
        this.list.setEnabled(true);
        this.exprChanged();
    }

    private void allRadioButtonActionPerformed(ActionEvent evt) {
        this.list.clearSelection();
        this.list.setEnabled(false);
        this.exprChanged();
    }

    private void checkBoxActionPerformed(ActionEvent evt) {
        this.spinner.setEnabled(this.checkBox.isSelected());
        this.exprChanged();
    }
}

