/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ScreenImage;
import javafx.scene.Node;
import org.mapton.api.MBackgroundImage;
import org.mapton.api.Mapton;
import org.mapton.worldwind.BackgroundImageOptionsView;
import org.mapton.worldwind.ModuleOptions;
import org.mapton.worldwind.api.LayerBundle;
import se.trixon.almond.util.Dict;

public class BackgroundImageLayerBundle
extends LayerBundle {
    private MBackgroundImage mBackgroundImage;
    private final RenderableLayer mLayer = new RenderableLayer();
    private final ModuleOptions mOptions = ModuleOptions.getInstance();
    private BackgroundImageOptionsView mOptionsView;
    private final ScreenImage mScreenImage = new ScreenImage();

    public BackgroundImageLayerBundle() {
        this.init();
        this.initRepaint();
        this.initListeners();
    }

    @Override
    public Node getOptionsView() {
        if (this.mOptionsView == null) {
            this.mOptionsView = new BackgroundImageOptionsView();
        }
        return this.mOptionsView;
    }

    @Override
    public void populate() throws Exception {
        this.getLayers().add((Object)this.mLayer);
        this.repaint(0L);
    }

    private void init() {
        this.mLayer.setName(Dict.BACKGROUND_IMAGE.toString());
        this.setCategorySystem((Layer)this.mLayer);
        this.setName(Dict.IMAGE.toString());
        this.mLayer.setEnabled(true);
        this.mLayer.setPickEnabled(false);
        this.setParentLayer((Layer)this.mLayer);
    }

    private void initListeners() {
        Mapton.getGlobalState().addListener(gsce -> {
            this.mBackgroundImage = (MBackgroundImage)gsce.getValue();
            this.repaint();
        }, new String[]{"background_image"});
        this.mOptions.getPreferences().addPreferenceChangeListener(pce -> this.repaint());
    }

    private void initRepaint() {
        this.setPainter(() -> {
            this.removeAllRenderables();
            if (this.mBackgroundImage != null && this.mBackgroundImage.getImageSource() != null) {
                this.mLayer.addRenderable((Renderable)this.mScreenImage);
                BackgroundImageLayerBundle backgroundImageLayerBundle = this;
                synchronized (backgroundImageLayerBundle) {
                    this.mScreenImage.setImageSource(this.mBackgroundImage.getImageSource());
                    try {
                        this.mScreenImage.setOpacity(this.mOptions.getDouble("background_image.opacity", new Double[]{1.0}));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.setDragEnabled(false);
        });
    }
}

