/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.Renderable;
import java.util.LinkedHashMap;
import javafx.scene.paint.Color;
import org.mapton.api.MBookmark;
import org.mapton.api.MBookmarkManager;
import org.mapton.api.Mapton;
import org.mapton.core.api.BookmarkEditor;
import org.mapton.worldwind.api.LayerBundle;
import org.mapton.worldwind.api.WWHelper;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;

public class BookmarkLayerBundle
extends LayerBundle {
    private final BookmarkEditor mBookmarkEditor = new BookmarkEditor();
    private final MBookmarkManager mBookmarkManager = MBookmarkManager.getInstance();
    private final RenderableLayer mLayer = new RenderableLayer();

    public BookmarkLayerBundle() {
        this.init();
        this.initRepaint();
        this.initListeners();
    }

    @Override
    public void populate() throws Exception {
        this.getLayers().add((Object)this.mLayer);
        this.repaint(2000L);
    }

    private void init() {
        this.mLayer.setName(Dict.BOOKMARKS.toString());
        this.setCategorySystem((Layer)this.mLayer);
        this.setName(Dict.BOOKMARKS.toString());
        this.mLayer.setEnabled(true);
        this.mLayer.setPickEnabled(true);
        this.setParentLayer((Layer)this.mLayer);
    }

    private void initListeners() {
        this.mBookmarkManager.getItems().addListener(c -> this.repaint());
    }

    private void initRepaint() {
        this.setPainter(() -> {
            this.removeAllRenderables();
            for (MBookmark bookmark : this.mBookmarkManager.getItems()) {
                if (!bookmark.isDisplayMarker().booleanValue()) continue;
                PointPlacemark placemark = new PointPlacemark(Position.fromDegrees((double)bookmark.getLatitude(), (double)bookmark.getLongitude()));
                placemark.setLabelText(bookmark.getName());
                placemark.setAltitudeMode(1);
                placemark.setEnableLabelPicking(true);
                PointPlacemarkAttributes attrs = new PointPlacemarkAttributes(placemark.getDefaultAttributes());
                attrs.setImageAddress("images/pushpins/plain-white.png");
                attrs.setImageColor(FxHelper.colorToColor((Color)FxHelper.colorFromHexRGBA((String)bookmark.getColor())));
                placemark.setAttributes(attrs);
                placemark.setHighlightAttributes(WWHelper.createHighlightAttributes(attrs, 1.5));
                placemark.setValue("mapton.runnable.left_click", () -> {
                    LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>();
                    propertyMap.put(Dict.NAME.toString(), bookmark.getName());
                    propertyMap.put(Dict.DESCRIPTION.toString(), bookmark.getDescription());
                    propertyMap.put(Dict.CATEGORY.toString(), bookmark.getCategory());
                    propertyMap.put(Dict.COLOR.toString(), (String)Color.web((String)bookmark.getColor()));
                    Mapton.getGlobalState().put("object.properties", propertyMap);
                });
                placemark.setValue("mapton.runnable.left_double_click", () -> this.mBookmarkEditor.editBookmark(bookmark));
                this.mLayer.addRenderable((Renderable)placemark);
            }
            this.setDragEnabled(false);
        });
    }
}

