/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import java.util.ArrayList;
import org.mapton.api.MCoordinateFile;
import org.mapton.api.MCoordinateFileManager;
import org.mapton.worldwind.api.CoordinateFileRendererWW;
import org.mapton.worldwind.api.LayerBundle;
import org.openide.util.Lookup;
import se.trixon.almond.util.Dict;

public class FilesLayerBundle
extends LayerBundle {
    private final MCoordinateFileManager mCoordinateFileManager = MCoordinateFileManager.getInstance();
    private final RenderableLayer mLayer = new RenderableLayer();

    public FilesLayerBundle() {
        this.init();
        this.initRepaint();
        this.initListeners();
        this.initRenderers();
    }

    @Override
    public void populate() throws Exception {
        this.getLayers().add((Object)this.mLayer);
        this.repaint(5000L);
    }

    private void init() {
        this.setParentLayer((Layer)this.mLayer);
        this.mLayer.setName(Dict.FILES.toString());
        this.setCategorySystem((Layer)this.mLayer);
        this.setName(Dict.FILES.toString());
        this.mLayer.setEnabled(true);
        this.mLayer.setPickEnabled(true);
        this.attachTopComponentToLayer("FilesTopComponent", (Layer)this.mLayer);
    }

    private void initListeners() {
        Lookup.Result result = Lookup.getDefault().lookupResult(CoordinateFileRendererWW.class);
        result.addLookupListener(lookupEvent -> {});
        this.mCoordinateFileManager.getItems().addListener(c -> {
            ArrayList renderers = new ArrayList(Lookup.getDefault().lookupAll(CoordinateFileRendererWW.class));
            while (c.next()) {
                c.getRemoved().forEach(coordinateFile -> renderers.forEach(renderer -> renderer.removeLayer((MCoordinateFile)coordinateFile)));
            }
        });
    }

    private void initRenderers() {
        for (CoordinateFileRendererWW coordinateFileRendererWW : Lookup.getDefault().lookupAll(CoordinateFileRendererWW.class)) {
            coordinateFileRendererWW.init(this);
        }
    }

    private void initRepaint() {
        this.setPainter(() -> this.setDragEnabled(false));
    }
}

