/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.Renderable;
import java.awt.Color;
import java.awt.Image;
import javafx.beans.property.BooleanProperty;
import org.mapton.api.MLatLon;
import org.mapton.api.MOptions;
import org.mapton.api.Mapton;
import org.mapton.worldwind.api.LayerBundle;
import org.mapton.worldwind.api.WWHelper;
import se.trixon.almond.util.GraphicsHelper;
import se.trixon.almond.util.icons.material.MaterialIcon;

public class HomeLayerBundle
extends LayerBundle {
    private final BooleanProperty mDisplayHomeIconProperty = MOptions.getInstance().displayHomeIconProperty();
    private final RenderableLayer mLayer = new RenderableLayer();
    private final MOptions mOptions = MOptions.getInstance();

    public HomeLayerBundle() {
        this.init();
        this.initRepaint();
        this.initListeners();
    }

    @Override
    public void populate() throws Exception {
        this.getLayers().add((Object)this.mLayer);
        this.repaint(0L);
    }

    private void init() {
        this.mLayer.setName("Home symbol");
        this.setVisibleInLayerManager((Layer)this.mLayer, false);
        this.mLayer.setEnabled(this.mDisplayHomeIconProperty.get());
        this.mLayer.setPickEnabled(false);
        this.setParentLayer((Layer)this.mLayer);
    }

    private void initListeners() {
        this.mDisplayHomeIconProperty.addListener((ov, t, t1) -> this.mLayer.setEnabled(t1.booleanValue()));
        this.mOptions.getPreferences().addPreferenceChangeListener(pce -> {
            switch (pce.getKey()) {
                case "map.home_lat": {
                    this.repaint();
                }
            }
        });
    }

    private void initRepaint() {
        this.setPainter(() -> {
            this.removeAllRenderables();
            MLatLon home = this.mOptions.getMapHome();
            PointPlacemark placemark = new PointPlacemark(Position.fromDegrees((double)home.getLatitude(), (double)home.getLongitude()));
            placemark.setAltitudeMode(1);
            PointPlacemarkAttributes attrs = new PointPlacemarkAttributes(placemark.getDefaultAttributes());
            attrs.setImage(GraphicsHelper.toBufferedImage((Image)MaterialIcon._Action.HOME.getImageIcon(Mapton.getIconSizeToolBar() * 2, Color.RED).getImage()));
            attrs.setImageOffset(Offset.CENTER);
            placemark.setAttributes(attrs);
            placemark.setHighlightAttributes(WWHelper.createHighlightAttributes(attrs, 1.0));
            this.mLayer.addRenderable((Renderable)placemark);
            this.setDragEnabled(false);
        });
    }
}

