/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceCircle;
import gov.nasa.worldwind.render.SurfacePolygon;
import java.awt.Color;
import java.util.ArrayList;
import org.mapton.worldwind.ModuleOptions;
import org.mapton.worldwind.api.LayerBundleManager;

public class MaskLayer
extends RenderableLayer {
    private final ModuleOptions mOptions = ModuleOptions.getInstance();
    private final ShapeAttributes mShapeAttributes = new BasicShapeAttributes();

    public MaskLayer() {
        this.setName("Mask");
        this.setPickEnabled(false);
        this.init();
        this.initListeners();
        this.refresh();
    }

    private void init() {
        this.mShapeAttributes.setDrawOutline(false);
        this.mShapeAttributes.setDrawInterior(true);
        int radius = 50000000;
        this.addRenderable((Renderable)new SurfaceCircle(this.mShapeAttributes, LatLon.fromDegrees((double)90.0, (double)0.0), (double)radius));
        this.addRenderable((Renderable)new SurfaceCircle(this.mShapeAttributes, LatLon.fromDegrees((double)-90.0, (double)0.0), (double)radius));
        double gap = 0.668646;
        int lonStep = 10;
        for (int lon = -180; lon < 180; lon += lonStep) {
            for (int lat = -1; lat < 2; ++lat) {
                ArrayList<LatLon> l = new ArrayList<LatLon>();
                l.add(LatLon.fromDegrees((double)((double)lat * 0.668646), (double)lon));
                l.add(LatLon.fromDegrees((double)((double)lat * 0.668646), (double)((double)lon + (double)lonStep)));
                l.add(LatLon.fromDegrees((double)0.0, (double)((double)lon + (double)lonStep)));
                l.add(LatLon.fromDegrees((double)0.0, (double)lon));
                this.addRenderable((Renderable)new SurfacePolygon(this.mShapeAttributes, l));
            }
        }
    }

    private void initListeners() {
        this.mOptions.getPreferences().addPreferenceChangeListener(evt -> {
            switch (evt.getKey()) {
                case "display_mask": 
                case "mask_color": 
                case "mask_opacity": {
                    this.refresh();
                }
            }
        });
    }

    private void refresh() {
        this.setEnabled(this.mOptions.is("display_mask", new boolean[]{false}));
        String colorString = this.mOptions.get("mask_color", new String[]{"ffffff"});
        Color c = Color.decode("0x" + colorString);
        float opacity = this.mOptions.getFloat("mask_opacity", new Float[]{Float.valueOf(0.5f)});
        this.mShapeAttributes.setInteriorMaterial(new Material(c));
        this.mShapeAttributes.setInteriorOpacity((double)opacity);
        try {
            LayerBundleManager.getInstance().redraw();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

