/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.BasicDragger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import javafx.scene.Node;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.mapton.api.MAttribution;
import org.mapton.api.MDocumentInfo;
import org.mapton.api.MEngine;
import org.mapton.api.MLatLon;
import org.mapton.api.MLatLonBox;
import org.mapton.api.Mapton;
import org.mapton.worldwind.LayerView;
import org.mapton.worldwind.ModuleOptions;
import org.mapton.worldwind.StyleView;
import org.mapton.worldwind.WorldWindowPanel;
import org.mapton.worldwind.api.LayerBundle;
import org.mapton.worldwind.api.MapStyle;
import org.mapton.worldwind.api.WWHelper;
import org.mapton.worldwind.ruler.RulerTabPane;
import org.openide.modules.Places;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.GlobalState;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.swing.SwingHelper;

public class WorldWindMapEngine
extends MEngine {
    public static final String LOG_TAG = "WorldWind";
    private BasicDragger mBasicDragger;
    private boolean mInProgress;
    private boolean mInitialized;
    private final LayerView mLayerView;
    private JPanel mMainPanel;
    private WorldWindowPanel mMap;
    private double mOldAltitude;
    private double mOldGlobalZoom;
    private final ModuleOptions mOptions = ModuleOptions.getInstance();
    private final RulerTabPane mRulerTabPane;
    private final StyleView mStyleView;
    private long mZoomEpoch = System.currentTimeMillis();
    private final double[] mZoomLevels;

    public WorldWindMapEngine() {
        System.setProperty("mapton.cache", Places.getCacheDirectory().getAbsolutePath());
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.DataFileStoreConfigurationFileName", (Object)"org/mapton/worldwind/CacheLocationConfiguration.xml");
        this.mStyleView = new StyleView();
        this.mLayerView = LayerView.getInstance();
        this.mRulerTabPane = RulerTabPane.getInstance();
        this.mZoomLevels = new double[]{4.8374812E7, 3.5820953E7, 2.4091408E7, 1.322164E7, 8019342.0, 3992765.0, 1089305.0, 444742.0, 244785.0, 121500.0, 56042.0, 27946.0, 17106.0, 7692.0, 3845.0, 2340.0, 959.0, 482.0, 294.0, 148.0, 84.0};
    }

    public void create(Runnable postCreateRunnable) {
        if (this.mMainPanel == null) {
            this.initMainPanel();
            new Thread(() -> {
                this.init();
                this.initListeners();
                SwingHelper.runLater(() -> {
                    this.mMainPanel.removeAll();
                    this.mMainPanel.add((Component)((Object)this.mMap), "Center");
                    postCreateRunnable.run();
                    this.mBasicDragger = new BasicDragger((WorldWindow)this.mMap);
                    this.mMap.addSelectListener((SelectListener)this.mBasicDragger);
                });
            }, ((Object)((Object)this)).getClass().getCanonicalName()).start();
        } else {
            postCreateRunnable.run();
        }
    }

    public void fitToBounds(ArrayList<Coordinate> coordinates) {
        if (!this.mInitialized || coordinates.isEmpty()) {
            return;
        }
        try {
            this.fitToBounds(WWHelper.sectorFromCoordinates(coordinates));
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void fitToBounds(Geometry geometry) {
        if (!this.mInitialized || geometry.getArea() == 0.0) {
            return;
        }
        try {
            this.fitToBounds(WWHelper.sectorFromGeometry(geometry));
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void fitToBounds(MLatLonBox latLonBox) {
        if (!this.mInitialized || latLonBox.getLatitudeSpan() == 0.0 && latLonBox.getLongitudeSpan() == 0.0) {
            return;
        }
        try {
            this.fitToBounds(WWHelper.sectorFromLatLonBox(latLonBox));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public MLatLon getCenter() {
        Vec4 centerPoint = this.mMap.getView().getCenterPoint();
        Position centerPosition = this.mMap.getView().getGlobe().computePositionFromPoint(centerPoint);
        return WWHelper.latLonFromPosition(centerPosition);
    }

    public Node getLayerView() {
        return this.mLayerView;
    }

    public WorldWindowPanel getMap() {
        return this.mMap;
    }

    public JComponent getMapComponent() {
        this.updateToolbarDocumentInfo();
        return this.mMainPanel;
    }

    public Node getMapNode() {
        throw new UnsupportedOperationException("Not supported yet, not ever.");
    }

    public String getName() {
        return LOG_TAG;
    }

    public Node getRulerView() {
        return this.mRulerTabPane;
    }

    public Node getStyleView() {
        return this.mStyleView;
    }

    public double getZoom() {
        return this.toGlobalZoom();
    }

    public void onActivate() {
        View view = this.mMap.getView();
        view.setHeading(Angle.fromDegrees((double)this.mOptions.getDouble("view_heading", new Double[0])));
        view.setPitch(Angle.fromDegrees((double)this.mOptions.getDouble("view_pitch", new Double[0])));
        view.setRoll(Angle.fromDegrees((double)this.mOptions.getDouble("view_roll", new Double[0])));
    }

    public void onClosing() {
        this.onDeactivate();
    }

    public void onDeactivate() {
        View view = this.mMap.getView();
        this.mOptions.put("view_heading", view.getHeading().getDegrees());
        this.mOptions.put("view_pitch", view.getPitch().getDegrees());
        this.mOptions.put("view_roll", view.getRoll().getDegrees());
        this.mOptions.put("view_altitude", view.getEyePosition().getAltitude());
    }

    public void onStyleSwap() {
        String prevStyle = (String)StringUtils.defaultIfBlank((CharSequence)this.mOptions.get("map_style_prev", new String[0]), (CharSequence)"at.eox.osm");
        String currentStyle = this.mOptions.get("map_style", new String[0]);
        this.mOptions.put("map_style", prevStyle);
        this.mOptions.put("map_style_prev", currentStyle);
    }

    public void onWhatsHere(String s) {
    }

    public void panTo(MLatLon latLon, double zoom) {
        if (this.mInitialized && SystemHelper.age((long)this.mZoomEpoch) > 1000L) {
            this.mMap.getView().goTo(WWHelper.positionFromLatLon(latLon), this.toLocalZoom(zoom));
        }
    }

    public void panTo(MLatLon latLon) {
        if (!this.mInitialized) {
            return;
        }
        View view = this.mMap.getView();
        Position eyePosition = view.getCurrentEyePosition();
        Angle fieldOfView = view.getFieldOfView();
        this.mMap.getView().goTo(WWHelper.positionFromLatLon(latLon), this.mMap.getView().getEyePosition().getAltitude());
        try {
            view.setEyePosition(eyePosition);
            view.setFieldOfView(fieldOfView);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void refreshUI() {
    }

    private void fitToBounds(Sector sector) {
        WorldWindow wwd = this.mMap.getWwd();
        if (sector == null) {
            throw new IllegalArgumentException();
        }
        Box boundingBox = Sector.computeBoundingBox((Globe)wwd.getModel().getGlobe(), (double)wwd.getSceneController().getVerticalExaggeration(), (Sector)sector);
        Angle fieldOfView = wwd.getView().getFieldOfView();
        double zoom = boundingBox.getRadius() / fieldOfView.cosHalfAngle() / fieldOfView.tanHalfAngle();
        wwd.getView().goTo(new Position(sector.getCentroid(), 0.0), zoom);
    }

    private void init() {
        this.mMap = new WorldWindowPanel(() -> {
            double zoom = this.mOptions.getDouble("view_altitude", new Double[]{-1.0});
            if (zoom != -1.0 && this.mMap.getView().getGlobe() != null) {
                this.mMap.getView().goTo(WWHelper.positionFromLatLon(this.options().getMapCenter()), zoom);
            }
        });
        this.mLayerView.refresh(this.mMap);
        this.mRulerTabPane.refresh((WorldWindow)this.mMap);
        this.setImageRenderer(this.mMap.getImageRenderer());
        Mapton.getLog().i(LOG_TAG, "Loaded and ready");
    }

    private void initListeners() {
        this.mMap.addMouseListener(new MouseAdapter(){
            private Point mPoint;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.mPoint = mouseEvent.getPoint();
                WorldWindMapEngine.this.hideContextMenu();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                double distance = this.mPoint.distance(mouseEvent.getPoint());
                if (mouseEvent.getButton() == 3 && distance < 3.0) {
                    WorldWindMapEngine.this.displayContextMenu(mouseEvent.getLocationOnScreen());
                }
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    WorldWindMapEngine.this.displayContextMenu(mouseEvent.getLocationOnScreen());
                }
            }
        });
        this.mMap.addPositionListener(positionEvent -> {
            Position position = positionEvent.getPosition();
            if (position != null) {
                double globalZoom;
                Double altitude = null;
                if (this.mMap.getView() != null && this.mMap.getView().getEyePosition() != null && Math.abs(this.mOldAltitude - (altitude = Double.valueOf(this.mMap.getView().getEyePosition().getElevation()))) > 1.0 && Math.abs(this.mOldGlobalZoom - (globalZoom = this.toGlobalZoom())) > (double)(1 / this.mZoomLevels.length)) {
                    this.mZoomEpoch = System.currentTimeMillis();
                    this.mOldGlobalZoom = globalZoom;
                    Mapton.getInstance().zoomProperty().set(globalZoom);
                }
                this.setStatusMousePositionData(WWHelper.latLonFromPosition(position), position.getElevation(), altitude);
            }
        });
        this.mMap.addGLEventListener(new GLEventListener(){
            private boolean runOnce = true;

            public void display(GLAutoDrawable drawable) {
                WorldWindMapEngine.this.mInitialized = true;
                if (this.runOnce) {
                    WorldWindMapEngine.this.initialized();
                    this.runOnce = false;
                    WorldWindMapEngine.this.mMap.addHierarchyBoundsListener(new HierarchyBoundsListener(){

                        @Override
                        public void ancestorMoved(HierarchyEvent e) {
                        }

                        @Override
                        public void ancestorResized(HierarchyEvent hierarchyEvent) {
                            try {
                                WorldWindMapEngine.this.mMap.redrawNow();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            }

            public void dispose(GLAutoDrawable drawable) {
            }

            public void init(GLAutoDrawable drawable) {
            }

            public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
            }
        });
        this.mMap.getWwd().addSelectListener(selectEvent -> {
            AVListImpl avListImpl;
            Object valueDragLayerBundle;
            Object topObject = selectEvent.getTopObject();
            if (topObject instanceof AVListImpl && (valueDragLayerBundle = (avListImpl = (AVListImpl)topObject).getValue("ww.drag.layer_bundle")) != null && valueDragLayerBundle instanceof LayerBundle) {
                LayerBundle layerBundle = (LayerBundle)valueDragLayerBundle;
                layerBundle.onSelectEvent(avListImpl.getValue("ww.drag.object"), selectEvent);
            }
        });
        this.mOptions.getPreferences().addPreferenceChangeListener(pce -> {
            switch (pce.getKey()) {
                case "map_style": {
                    this.updateToolbarDocumentInfo();
                    break;
                }
            }
        });
        Timer downloadTimer = new Timer(100, event -> {
            boolean inProgress = WorldWind.getRetrievalService().hasActiveTasks();
            if (this.mInProgress != inProgress) {
                this.mInProgress = inProgress;
                this.setStatusProgress(this.mInProgress ? -1.0 : 1.0);
            }
        });
        downloadTimer.start();
    }

    private void initMainPanel() {
        this.mMainPanel = new JPanel(new BorderLayout());
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        this.mMainPanel.add((Component)progressBar, "North");
        JLabel label = new JLabel("<html>%s<br/><br/><br/></html>".formatted(Dict.PATIENCE_IS_A_VIRTUE.toString()));
        label.setVerticalAlignment(3);
        label.setFont(label.getFont().deriveFont((float)label.getFont().getSize() * 2.0f));
        label.setHorizontalAlignment(0);
        this.mMainPanel.add((Component)label, "Center");
    }

    private double toGlobalZoom() {
        double altitude = this.mMap.getView().getEyePosition().getAltitude();
        int level = 0;
        for (int i = 0; i < this.mZoomLevels.length; ++i) {
            if (altitude >= this.mZoomLevels[i]) {
                level = i;
                break;
            }
            if (i != this.mZoomLevels.length - 1) continue;
            level = this.mZoomLevels.length;
        }
        return (double)level / (double)this.mZoomLevels.length;
    }

    private double toLocalZoom(double globalZoom) {
        return this.mZoomLevels[(int)((double)(this.mZoomLevels.length - 1) * globalZoom)];
    }

    private void updateToolbarDocumentInfo() {
        GlobalState globalState = Mapton.getGlobalState();
        String styleId = this.mOptions.get("map_style", new String[]{"at.eox.osm"});
        TreeMap globalAttributions = (TreeMap)globalState.get("data_sources.wms.attributions");
        LinkedHashMap<String, MAttribution> attributions = new LinkedHashMap<String, MAttribution>();
        MapStyle mapStyle = MapStyle.getStyle(styleId);
        String[] layers = MapStyle.getLayers(styleId);
        if (layers != null) {
            for (String layer : layers) {
                if (!globalAttributions.containsKey(layer)) continue;
                attributions.put(layer, (MAttribution)globalAttributions.get(layer));
            }
        }
        MDocumentInfo documentInfo = new MDocumentInfo(mapStyle.getName(), attributions);
        globalState.put("map.document.info", (Object)documentInfo);
    }
}

