/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind;

import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.awt.WorldWindowGLJPanel;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.globes.EarthFlat;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.globes.FlatGlobe;
import gov.nasa.worldwind.globes.GeographicProjection;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.projections.ProjectionEquirectangular;
import gov.nasa.worldwind.globes.projections.ProjectionMercator;
import gov.nasa.worldwind.globes.projections.ProjectionModifiedSinusoidal;
import gov.nasa.worldwind.globes.projections.ProjectionPolarEquidistant;
import gov.nasa.worldwind.globes.projections.ProjectionSinusoidal;
import gov.nasa.worldwind.globes.projections.ProjectionTransverseMercator;
import gov.nasa.worldwind.globes.projections.ProjectionUPS;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.CrosshairLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.SurfaceImageLayer;
import gov.nasa.worldwind.layers.ViewControlsLayer;
import gov.nasa.worldwind.layers.ViewControlsSelectListener;
import gov.nasa.worldwind.layers.WorldMapLayer;
import gov.nasa.worldwind.render.Highlightable;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.WWIcon;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwind.terrain.LocalElevationModel;
import gov.nasa.worldwind.terrain.ZeroElevationModel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.swing.Icon;
import javax.xml.stream.XMLStreamException;
import org.mapton.api.MDict;
import org.mapton.api.MNotificationIcons;
import org.mapton.api.MOptions;
import org.mapton.api.MWmsSource;
import org.mapton.api.Mapton;
import org.mapton.core.api.MaptonNb;
import org.mapton.worldwind.IndicatorLayerBundle;
import org.mapton.worldwind.MaskLayer;
import org.mapton.worldwind.ModuleOptions;
import org.mapton.worldwind.api.LayerBundle;
import org.mapton.worldwind.api.MapStyle;
import org.mapton.worldwind.api.WmsService;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.GraphicsHelper;
import se.trixon.almond.util.swing.FileHelper;

public class WorldWindowPanel
extends WorldWindowGLJPanel {
    private CrosshairLayer mCrosshairLayer;
    private final ObservableList<Layer> mCustomLayers = FXCollections.observableArrayList();
    private FlatGlobe mFlatGlobe;
    private IndicatorLayerBundle mIndicatorLayer;
    private Object mLastHighlightObject;
    private String mLastHighlightText;
    private CompoundElevationModel mNormalElevationModel;
    private final ModuleOptions mOptions = ModuleOptions.getInstance();
    private Globe mRoundGlobe;
    private final ElevationModel mZeroElevationModel = new ZeroElevationModel();

    public WorldWindowPanel(Runnable postCreateRunnable) {
        MaptonNb.progressStart((String)MDict.MAP_ENGINE.toString());
        this.init();
        new Thread(() -> {
            this.initFinalize();
            this.initListeners();
            postCreateRunnable.run();
        }, ((Object)((Object)this)).getClass().getCanonicalName()).start();
    }

    public void addCustomLayer(Layer layer) {
        if (!this.getLayers().contains((Object)layer)) {
            Mapton.logLoading((String)"Custom Layer", (String)layer.getName());
            this.mCustomLayers.add((Object)layer);
            this.insertLayerBefore(layer, CompassLayer.class);
            this.moveSurfaceImageLayersToTop();
        }
    }

    public WorldWindow getWwd() {
        return this.wwd;
    }

    public void removeCustomLayer(Layer layer) {
        if (this.getLayers().contains((Object)layer)) {
            Mapton.logLoading((String)"Custom Layer", (String)layer.getName());
            this.mCustomLayers.remove((Object)layer);
            this.getLayers().remove(layer);
        }
    }

    ObservableList<Layer> getCustomLayers() {
        return this.mCustomLayers;
    }

    Callable<BufferedImage> getImageRenderer() {
        return () -> {
            BufferedImage image = GraphicsHelper.componentToImage((Component)((Object)this), null);
            return image;
        };
    }

    LayerList getLayers() {
        return this.getModel().getLayers();
    }

    private void customElevationModelLoad(File dir) {
        System.out.println("customElevationModelLoad " + dir.getAbsolutePath());
        LocalElevationModel localElevationModel = new LocalElevationModel();
        for (File file : dir.listFiles()) {
            if (!file.isFile()) continue;
            try {
                System.out.println("load elevation model " + file.getAbsolutePath());
                localElevationModel.addElevations(file);
                this.mNormalElevationModel.addElevationModel((ElevationModel)localElevationModel);
            }
            catch (BufferUnderflowException e) {
                System.out.println(e.getMessage());
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    private void customElevationModelRefresh() {
        Thread thread = new Thread(() -> {
            File dir = new File(FileHelper.getDefaultDirectory(), "test/dem");
            if (dir.isDirectory()) {
                this.customElevationModelLoad(dir);
            }
        }, ((Object)((Object)this)).getClass().getCanonicalName());
        thread.setPriority(1);
        thread.start();
    }

    private GeographicProjection getProjection() {
        switch (this.mOptions.getInt("map_projection", new Integer[0])) {
            case 1: {
                return new ProjectionMercator();
            }
            case 2: {
                return new ProjectionPolarEquidistant("gov.nasa.worldwind.avkey.North");
            }
            case 3: {
                return new ProjectionPolarEquidistant("gov.nasa.worldwdind.avkey.South");
            }
            case 4: {
                return new ProjectionSinusoidal();
            }
            case 5: {
                return new ProjectionModifiedSinusoidal();
            }
            case 6: {
                return new ProjectionTransverseMercator(this.getView().getCurrentEyePosition().getLongitude());
            }
            case 7: {
                return new ProjectionUPS("gov.nasa.worldwind.avkey.North");
            }
            case 8: {
                return new ProjectionUPS("gov.nasa.worldwdind.avkey.South");
            }
        }
        return new ProjectionEquirectangular();
    }

    private void init() {
        Model model = (Model)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.ModelClassName");
        this.setModel(model);
        this.mRoundGlobe = model.getGlobe();
        this.mFlatGlobe = new EarthFlat();
        this.mFlatGlobe.setElevationModel((ElevationModel)new ZeroElevationModel());
        ViewControlsLayer viewControlsLayer = new ViewControlsLayer();
        this.insertLayerBefore((Layer)viewControlsLayer, CompassLayer.class);
        this.addSelectListener((SelectListener)new ViewControlsSelectListener((WorldWindow)this, viewControlsLayer));
        MaskLayer maskLayer = new MaskLayer();
        this.insertLayerBefore((Layer)maskLayer, WorldMapLayer.class);
        this.mCrosshairLayer = new CrosshairLayer();
        this.mCrosshairLayer.setIconFilePath("org/mapton/worldwind/crosshair.png");
        this.mCrosshairLayer.setIconScale(0.16);
        this.mCrosshairLayer.setEnabled(MOptions.getInstance().isDisplayCrosshair());
        this.insertLayerBefore((Layer)this.mCrosshairLayer, WorldMapLayer.class);
        this.mNormalElevationModel = (CompoundElevationModel)this.wwd.getModel().getGlobe().getElevationModel();
        this.wwd.getModel().getGlobe().setElevationModel(this.mZeroElevationModel);
        this.wwd.getSceneController().setDeepPickEnabled(true);
        this.mIndicatorLayer = new IndicatorLayerBundle();
        this.mIndicatorLayer.populate();
    }

    private void initFinalize() {
        this.updateScreenLayers();
        this.updateMode();
        this.updateProjection();
        this.updateElevation();
        MaptonNb.progressStop((String)MDict.MAP_ENGINE.toString());
        Mapton.getExecutionFlow().setReady("execution_flow_map_ww_initialized");
        this.initLayerBundles();
        this.initWmsService();
        this.updateStyle();
        this.customElevationModelRefresh();
    }

    private void initLayerBundles() {
        for (LayerBundle layerBundle : Lookup.getDefault().lookupAll(LayerBundle.class)) {
            if (layerBundle.isPopulated()) continue;
            try {
                layerBundle.populate();
                layerBundle.setPopulated(true);
                layerBundle.getLayers().forEach(layer -> {
                    layer.setValue("layerBundle", (Object)layerBundle);
                    this.addCustomLayer((Layer)layer);
                });
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            layerBundle.getLayers().addListener(c -> {
                while (c.next()) {
                    if (c.wasAdded()) {
                        c.getAddedSubList().forEach(layer -> this.addCustomLayer((Layer)layer));
                    }
                    if (!c.wasRemoved()) continue;
                    c.getRemoved().forEach(layer -> this.removeCustomLayer((Layer)layer));
                }
            });
        }
        this.addCustomLayer((Layer)this.mIndicatorLayer.getLayers().get(0));
    }

    private void initListeners() {
        this.mOptions.getPreferences().addPreferenceChangeListener(pce -> {
            switch (pce.getKey()) {
                case "map_opacity": 
                case "map_style": {
                    this.updateStyle();
                    break;
                }
                case "map_elevation": {
                    this.updateElevation();
                    break;
                }
                case "map_mode": {
                    this.updateMode();
                    break;
                }
                case "map_projection": {
                    this.updateProjection();
                    break;
                }
                case "display_atmosphere": 
                case "display_compass": 
                case "display_controls2": 
                case "display_place_names2": 
                case "display_scale_bar": 
                case "display_stars": 
                case "display_world_map": {
                    this.updateScreenLayers();
                    break;
                }
            }
        });
        Mapton.getGlobalState().addListener(gsce -> this.initWmsService(), new String[]{"data_sources.wms.sources"});
        Lookup.getDefault().lookupResult(LayerBundle.class).addLookupListener(lookupEvent -> this.initLayerBundles());
        Lookup.getDefault().lookupResult(WmsService.class).addLookupListener(lookupEvent -> this.initWmsService());
        MouseAdapter highlightClickAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Object object;
                if (mouseEvent.getButton() == 1 && WorldWindowPanel.this.mLastHighlightObject != null && (object = WorldWindowPanel.this.mLastHighlightObject) instanceof AVList) {
                    Runnable r;
                    AVList avList = (AVList)object;
                    if (mouseEvent.getClickCount() == 1) {
                        r = (Runnable)avList.getValue("mapton.runnable.left_click");
                        if (r != null) {
                            r.run();
                        }
                    } else if (mouseEvent.getClickCount() == 2 && (r = (Runnable)avList.getValue("mapton.runnable.left_double_click")) != null) {
                        r.run();
                    }
                }
            }
        };
        SelectListener rolloverSelectListener = new SelectListener(){

            public void selected(SelectEvent event) {
                if (event.isRollover()) {
                    this.highlight(event.getTopObject());
                }
            }

            private void highlight(Object o) {
                AVList avList;
                Runnable r;
                Highlightable highlightable;
                Object wwIcon;
                PointPlacemark pointPlacemark;
                Object object;
                if (WorldWindowPanel.this.mLastHighlightObject == o) {
                    return;
                }
                if (WorldWindowPanel.this.mLastHighlightObject != null) {
                    object = WorldWindowPanel.this.mLastHighlightObject;
                    if (object instanceof PointPlacemark) {
                        pointPlacemark = (PointPlacemark)object;
                        pointPlacemark.setAlwaysOnTop(false);
                        pointPlacemark.setHighlighted(false);
                        if (pointPlacemark.hasKey("mapton.hoover.text")) {
                            pointPlacemark.setLabelText(WorldWindowPanel.this.mLastHighlightText);
                        }
                    } else {
                        object = WorldWindowPanel.this.mLastHighlightObject;
                        if (object instanceof WWIcon) {
                            wwIcon = (WWIcon)object;
                            wwIcon.setAlwaysOnTop(false);
                            wwIcon.setHighlighted(false);
                        } else {
                            object = WorldWindowPanel.this.mLastHighlightObject;
                            if (object instanceof Highlightable) {
                                highlightable = (Highlightable)object;
                                highlightable.setHighlighted(false);
                            }
                        }
                    }
                    WorldWindowPanel.this.mLastHighlightObject = null;
                }
                if ((object = (WorldWindowPanel.this.mLastHighlightObject = o)) instanceof PointPlacemark) {
                    pointPlacemark = (PointPlacemark)object;
                    pointPlacemark.setAlwaysOnTop(true);
                    pointPlacemark.setHighlighted(true);
                    if (pointPlacemark.hasKey("mapton.hoover.text")) {
                        WorldWindowPanel.this.mLastHighlightText = pointPlacemark.getLabelText();
                        pointPlacemark.setLabelText(pointPlacemark.getStringValue("mapton.hoover.text"));
                    }
                } else {
                    object = WorldWindowPanel.this.mLastHighlightObject;
                    if (object instanceof WWIcon) {
                        wwIcon = (WWIcon)object;
                        wwIcon.setAlwaysOnTop(true);
                        wwIcon.setHighlighted(true);
                    } else {
                        object = WorldWindowPanel.this.mLastHighlightObject;
                        if (object instanceof Highlightable) {
                            highlightable = (Highlightable)object;
                            highlightable.setHighlighted(true);
                        }
                    }
                }
                if ((wwIcon = WorldWindowPanel.this.mLastHighlightObject) instanceof AVList && (r = (Runnable)(avList = (AVList)wwIcon).getValue("mapton.runnable.hoover")) != null) {
                    r.run();
                }
            }
        };
        this.getWwd().addSelectListener(rolloverSelectListener);
        this.getWwd().getInputHandler().addMouseListener((MouseListener)highlightClickAdapter);
        MOptions.getInstance().displayCrosshairProperty().addListener((observable, oldValue, newValue) -> this.mCrosshairLayer.setEnabled(newValue.booleanValue()));
    }

    private void initWmsService() {
        ArrayList<WmsService> wmsServices = new ArrayList<WmsService>(Lookup.getDefault().lookupAll(WmsService.class));
        ArrayList wmsSources = (ArrayList)Mapton.getGlobalState().get("data_sources.wms.sources");
        if (wmsSources != null) {
            for (MWmsSource wmsSource : wmsSources) {
                wmsServices.add(WmsService.createFromWmsSource(wmsSource));
            }
        }
        for (WmsService wmsService : wmsServices) {
            if (wmsService.isPopulated()) continue;
            new Thread(() -> {
                try {
                    wmsService.populate();
                    for (Layer layer : wmsService.getLayers()) {
                        Mapton.logLoading((String)"WMS Layer", (String)layer.getName());
                        layer.setEnabled(false);
                        this.getLayers().addIfAbsent(layer);
                    }
                    this.updateStyle();
                }
                catch (SocketTimeoutException ex) {
                    Mapton.getLog().w("WorldWind", ex.toString());
                }
                catch (XMLStreamException ex) {
                    Mapton.getLog().w("WorldWind", ex.toString());
                }
                catch (WWRuntimeException ex) {
                    System.err.println(ex.toString());
                    NotificationDisplayer.getDefault().notify(Dict.Dialog.TITLE_IO_ERROR.toString(), (Icon)MNotificationIcons.getErrorIcon(), "WMS error: %s".formatted(wmsService.getName()), null, NotificationDisplayer.Priority.HIGH);
                    Mapton.getLog().e("WorldWind", ex.toString());
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }).start();
        }
    }

    private void insertLayerBefore(Layer aLayer, Class type) {
        int position = 0;
        LayerList layers = this.getLayers();
        for (Layer layer : this.getLayers()) {
            if (!type.isInstance(layer)) continue;
            position = layers.indexOf((Object)layer);
            break;
        }
        layers.add(position, aLayer);
    }

    private boolean isFlatGlobe() {
        return this.getModel().getGlobe() instanceof FlatGlobe;
    }

    private void moveSurfaceImageLayersToTop() {
        for (Layer layer : this.getLayers()) {
            if (!(layer instanceof SurfaceImageLayer)) continue;
            this.getLayers().remove(layer);
            this.getLayers().add(layer);
        }
    }

    private synchronized void orderLayers(String[] styleLayers) {
        if (styleLayers == null) {
            return;
        }
        LayerList allLayers = this.getLayers();
        List<String> documentLayers = Arrays.asList(styleLayers);
        Collections.reverse(documentLayers);
        for (String layerName : documentLayers) {
            Layer layer = allLayers.getLayerByName(layerName);
            if (layer != null) {
                allLayers.remove(layer);
                allLayers.add(layer);
                continue;
            }
            Mapton.getLog().e(Dict.DOCUMENT.toString(), "Layer not found: " + layerName);
        }
        this.moveSurfaceImageLayersToTop();
    }

    private void updateElevation() {
        this.wwd.getModel().getGlobe().setElevationModel((ElevationModel)(this.mOptions.is("map_elevation", new boolean[]{false}) ? this.mNormalElevationModel : this.mZeroElevationModel));
        this.wwd.redraw();
    }

    private void updateMode() {
        boolean flat;
        boolean bl = flat = !this.mOptions.is("map_mode", new boolean[0]);
        if (this.isFlatGlobe() == flat) {
            // empty if block
        }
        if (flat) {
            this.getModel().setGlobe((Globe)this.mFlatGlobe);
            this.getView().stopMovement();
        } else {
            this.getModel().setGlobe(this.mRoundGlobe);
            this.getView().stopMovement();
            this.updateProjection();
        }
        this.redraw();
    }

    private void updateProjection() {
        if (!this.isFlatGlobe()) {
            return;
        }
        this.mFlatGlobe.setProjection(this.getProjection());
        this.redraw();
    }

    private void updateScreenLayers() {
        this.getLayers().getLayerByName("Compass").setEnabled(this.mOptions.is("display_compass", new boolean[]{true}));
        this.getLayers().getLayerByName("World Map").setEnabled(this.mOptions.is("display_world_map", new boolean[]{false}));
        this.getLayers().getLayerByName("Scale bar").setEnabled(this.mOptions.is("display_scale_bar", new boolean[]{true}));
        this.getLayers().getLayerByName("View Controls").setEnabled(this.mOptions.is("display_controls2", new boolean[]{false}));
        this.getLayers().getLayerByName("Atmosphere").setEnabled(this.mOptions.is("display_atmosphere", new boolean[]{true}));
        this.getLayers().getLayerByName("Stars").setEnabled(this.mOptions.is("display_stars", new boolean[]{true}));
        this.getLayers().getLayerByName("Place Names").setEnabled(this.mOptions.is("display_place_names2", new boolean[]{false}));
        this.redraw();
    }

    private synchronized void updateStyle() {
        HashSet<String> blacklist = new HashSet<String>();
        blacklist.add("Compass");
        blacklist.add("World Map");
        blacklist.add("Scale bar");
        blacklist.add("View Controls");
        blacklist.add("Stars");
        blacklist.add("Atmosphere");
        blacklist.add("Place Names");
        blacklist.add("Measure Tool");
        blacklist.add("Mask");
        blacklist.add("Crosshairs");
        String styleId = this.mOptions.get("map_style", new String[]{"at.eox.osm"});
        CharSequence[] styleLayers = MapStyle.getLayers(styleId);
        MapStyle mapStyle = MapStyle.getStyle(styleId);
        try {
            Mapton.getLog().i(Dict.DOCUMENT.toString(), "%s: (%s)".formatted(mapStyle.getName(), String.join((CharSequence)", ", styleLayers)));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.getLayers().forEach(arg_0 -> this.lambda$updateStyle$13(blacklist, (String[])styleLayers, arg_0));
        this.orderLayers((String[])styleLayers);
        this.redraw();
    }

    private /* synthetic */ void lambda$updateStyle$13(HashSet blacklist, String[] styleLayers, Layer layer) {
        try {
            String name = layer.getName();
            if (!blacklist.contains(name) && !this.mCustomLayers.contains((Object)layer)) {
                layer.setEnabled(Arrays.asList(styleLayers).contains(name));
                layer.setOpacity(this.mOptions.getDouble("map_opacity", new Double[]{1.0}));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

