/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.api;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.render.Renderable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mapton.api.MCooTrans;
import org.mapton.api.MCoordinateFile;
import org.mapton.api.MCoordinateFileManager;
import org.mapton.api.MCoordinateFileOpener;
import org.mapton.core.api.MaptonNb;
import org.mapton.worldwind.api.LayerBundle;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.swing.DelayedResetRunner;

public abstract class CoordinateFileRendererWW {
    public static final ConcurrentHashMap<String, ArrayList<Renderable>> DIGEST_RENDERABLE_MAP = new ConcurrentHashMap();
    protected MCooTrans mCooTrans;
    protected final MCoordinateFileManager mCoordinateFileManager = MCoordinateFileManager.getInstance();
    protected Layer mParentLayer;
    private final HashMap<MCoordinateFile, Layer> mCoordinateFileToLayer = new HashMap();
    private LayerBundle mLayerBundle;
    private final Set<String> mSupportedFileOpeners = new HashSet<String>();

    public CoordinateFileRendererWW() {
        this.initListeners();
    }

    public void addLayer(MCoordinateFile coordinateFile, Layer layer) {
        this.getLayerBundle().getLayers().add((Object)layer);
        this.getLayerBundle().addAllChildLayers(layer);
        this.mCoordinateFileToLayer.put(coordinateFile, layer);
        this.messageStop(coordinateFile);
    }

    public LayerBundle getLayerBundle() {
        return this.mLayerBundle;
    }

    public Set<String> getSupportedFileOpeners() {
        return this.mSupportedFileOpeners;
    }

    public abstract void init(LayerBundle var1);

    public void removeLayer(MCoordinateFile coordinateFile) {
        Layer layer = this.mCoordinateFileToLayer.remove(coordinateFile);
        if (layer != null) {
            this.getLayerBundle().getLayers().remove((Object)layer);
        }
    }

    public void setDragEnabled(boolean enabled) {
        this.mLayerBundle.setDragEnabled(enabled);
    }

    public void setLayerBundle(LayerBundle layerBundle) {
        this.mLayerBundle = layerBundle;
        this.mParentLayer = this.mLayerBundle.getParentLayer();
        this.mParentLayer.addPropertyChangeListener(pce -> {
            if (pce.getPropertyName().equals("Enabled") && ((Boolean)pce.getNewValue()).booleanValue()) {
                this.render();
            }
        });
    }

    protected void addSupportedFileOpeners(Class<? extends MCoordinateFileOpener> ... coordinateFileOpeners) {
        for (Class<? extends MCoordinateFileOpener> coordinateFileOpener : coordinateFileOpeners) {
            this.mSupportedFileOpeners.add(coordinateFileOpener.getName());
        }
    }

    protected abstract void load(MCoordinateFile var1);

    protected abstract void render();

    protected synchronized void render(MCoordinateFile coordinateFile) {
        boolean visible = coordinateFile.isVisible();
        if (this.mCoordinateFileToLayer.containsKey(coordinateFile)) {
            Layer layer = this.mCoordinateFileToLayer.get(coordinateFile);
            layer.setEnabled(visible);
            layer.setValue("map.layer.sub_visibility", (Object)visible);
        } else {
            if (!visible) {
                return;
            }
            this.messageStart(coordinateFile);
            this.load(coordinateFile);
        }
    }

    private void initListeners() {
        DelayedResetRunner delayedResetRunner = new DelayedResetRunner(100, () -> {
            if (this.mParentLayer != null && this.mParentLayer.isEnabled()) {
                this.render();
            }
        });
        this.mCoordinateFileManager.getItems().addListener(c -> delayedResetRunner.reset());
        this.mCoordinateFileManager.updatedProperty().addListener((observable, oldValue, newValue) -> delayedResetRunner.reset());
    }

    private void messageStart(MCoordinateFile coordinateFile) {
        MaptonNb.progressStart((String)Dict.OPENING_S.toString().formatted(coordinateFile.getFile().getName()));
    }

    private void messageStop(MCoordinateFile coordinateFile) {
        MaptonNb.progressStop((String)Dict.OPENING_S.toString().formatted(coordinateFile.getFile().getName()));
    }
}

