/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.api.analytic;

import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.WWMath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import org.mapton.api.MLatLonBox;
import org.mapton.worldwind.api.analytic.GridData;
import org.mapton.worldwind.api.worldwind.AnalyticSurface;
import org.mapton.worldwind.api.worldwind.AnalyticSurfaceAttributes;
import se.trixon.almond.util.MathHelper;

public class AnalyticGrid {
    public static final double HUE_BLUE = 0.6666666666666666;
    public static final double HUE_RED = 0.0;
    private final AnalyticSurfaceAttributes mAttributes = new AnalyticSurfaceAttributes();
    private Dimension mDimension;
    private boolean mDynamicMinMax;
    private GridData mGridData;
    private int mHeight;
    private final RenderableLayer mLayer;
    private Renderable mLegend;
    private double mMax;
    private double mMaxHue = 0.0;
    private double mMin;
    private double mMinHue = 0.6666666666666666;
    private double mNullOpacity = 0.0;
    private final AnalyticSurface mSurface = new AnalyticSurface();
    private int mWidth;
    private double mZeroOpacity = 1.0;
    private int mZeroValueSearchRange = 4;

    public AnalyticGrid(RenderableLayer layer, double altitude) {
        this(layer, altitude, -1.0, -1.0);
        this.mDynamicMinMax = true;
    }

    public AnalyticGrid(RenderableLayer layer, double altitude, double min, double max) {
        this.mLayer = layer;
        this.mMin = min;
        this.mMax = max;
        this.mSurface.setAltitude(altitude);
        this.mSurface.setClientLayer((Layer)this.mLayer);
        this.mAttributes.setShadowOpacity(0.5);
        this.mAttributes.setDrawOutline(false);
        this.mSurface.setSurfaceAttributes(this.mAttributes);
    }

    public AnalyticSurfaceAttributes getAttributes() {
        return this.mAttributes;
    }

    public AnalyticSurface getSurface() {
        return this.mSurface;
    }

    public void setGridData(GridData gridData) {
        this.mGridData = gridData;
        this.mWidth = gridData.getWidth();
        this.mHeight = gridData.getHeight();
        MLatLonBox latLonBox = gridData.getLatLonBox();
        this.mSurface.setSector(Sector.fromDegrees((double)latLonBox.getSouthWest().getLatitude(), (double)latLonBox.getNorthEast().getLatitude(), (double)latLonBox.getSouthWest().getLongitude(), (double)latLonBox.getNorthEast().getLongitude()));
        this.mSurface.setDimensions(this.mWidth, this.mHeight);
        this.mDimension = new Dimension(this.mWidth, this.mHeight);
        if (this.mDynamicMinMax) {
            this.mMin = gridData.getMin();
            this.mMax = gridData.getMax();
        }
        ArrayList<AnalyticSurface.GridPointAttributes> gridPointAttributeses = new ArrayList<AnalyticSurface.GridPointAttributes>();
        double[] values = gridData.getGridAggregates();
        for (int i = 0; i < values.length; ++i) {
            gridPointAttributeses.add(this.createColorGradientAttributes(i, values, this.mMin, this.mMax));
        }
        this.mSurface.setValues(gridPointAttributeses);
        if (this.mLayer != null) {
            this.mLayer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, (Object)this.mLayer);
        }
    }

    public void setLegendVisible(boolean visible) {
        if (visible) {
            this.mLayer.addRenderable(this.mLegend);
        } else {
            this.mLayer.removeRenderable(this.mLegend);
        }
    }

    public void setMaxHue(double maxHue) {
        this.mMaxHue = maxHue;
    }

    public void setMinHue(double minHue) {
        this.mMinHue = minHue;
    }

    public void setNullOpacity(double nullOpacity) {
        this.mNullOpacity = nullOpacity;
    }

    public void setZeroOpacity(double zeroOpacity) {
        this.mZeroOpacity = zeroOpacity;
    }

    public void setZeroValueSearchRange(int zeroValueSearchRange) {
        this.mZeroValueSearchRange = zeroValueSearchRange;
    }

    private AnalyticSurface.GridPointAttributes createColorGradientAttributes(int pos, double[] values, double minValue, double maxValue) {
        double value = values[pos];
        double hueFactor = WWMath.computeInterpolationFactor((double)value, (double)minValue, (double)maxValue);
        double opacity = 1.0;
        Color color = Color.getHSBColor((float)WWMath.mixSmooth((double)hueFactor, (double)this.mMinHue, (double)this.mMaxHue), 1.0f, 1.0f);
        if (value == 0.0) {
            Point valuePoint = MathHelper.indexToPoint((int)pos, (Dimension)this.mDimension);
            opacity = this.mNullOpacity;
            block2: for (int x = -this.mZeroValueSearchRange; x < this.mZeroValueSearchRange + 1; ++x) {
                for (int y = -this.mZeroValueSearchRange; y < this.mZeroValueSearchRange + 1; ++y) {
                    Point neighborPoint = new Point(valuePoint.x + x, valuePoint.y + y);
                    if (neighborPoint.x <= -1 || neighborPoint.x >= this.mWidth) continue;
                    int idx = MathHelper.pointToIndex((Point)neighborPoint, (Dimension)this.mDimension);
                    try {
                        if (values[idx] == 0.0) continue;
                        opacity = this.mZeroOpacity;
                        break block2;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
        }
        Color rgbaColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * opacity));
        return AnalyticSurface.createGridPointAttributes(value, rgbaColor);
    }
}

