/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.api.analytic;

import gov.nasa.worldwind.util.BufferFactory;
import gov.nasa.worldwind.util.BufferWrapper;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.stream.DoubleStream;
import org.mapton.api.MLatLon;
import org.mapton.api.MLatLonBox;
import org.mapton.worldwind.api.analytic.CellAggregate;
import org.mapton.worldwind.api.analytic.GridValue;
import se.trixon.almond.util.MathHelper;

public class GridData {
    private CellAggregate mCellAggregate;
    private ArrayList<Double>[][] mCellValues;
    private int mHeight;
    private MLatLonBox mLatLonBox;
    private double mMax = Double.MIN_VALUE;
    private double mMin = Double.MAX_VALUE;
    private ArrayList<GridValue> mValues;
    private int mWidth;

    public GridData() {
    }

    public GridData(int width, int height, ArrayList<GridValue> values, CellAggregate cellAggregate) {
        this.mCellAggregate = cellAggregate;
        ArrayList latLons = new ArrayList();
        values.forEach(gridValue -> {
            latLons.add(gridValue.getLatLon());
            if (gridValue.getValue() != null) {
                this.mMin = Math.min(this.mMin, gridValue.getValue());
                this.mMax = Math.max(this.mMax, gridValue.getValue());
            }
        });
        this.mLatLonBox = new MLatLonBox(latLons);
        this.mWidth = width;
        this.mHeight = height;
        this.mCellValues = new ArrayList[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                this.mCellValues[x][y] = new ArrayList();
            }
        }
        this.setValues(values);
    }

    public CellAggregate getCellAggregate() {
        return this.mCellAggregate;
    }

    public Double getCellAverage(Point p) {
        return this.getCellDoubles(p).average().orElse(0.0);
    }

    public int getCellCount(Point p) {
        return this.getCellValues(p).size();
    }

    public Double getCellMax(Point p) {
        return this.getCellDoubles(p).max().orElse(0.0);
    }

    public Double getCellMedian(Point p) {
        ArrayList<Double> list = this.getCellValues(p);
        if (list.isEmpty()) {
            return 0.0;
        }
        DoubleStream sortedValues = list.stream().mapToDouble(Double::doubleValue).sorted();
        double median = list.size() % 2 == 0 ? sortedValues.skip((long)(list.size() / 2) - 1L).limit(2L).average().getAsDouble() : sortedValues.skip(list.size() / 2).findFirst().getAsDouble();
        return median;
    }

    public Double getCellMin(Point p) {
        return this.getCellDoubles(p).min().orElse(0.0);
    }

    public Double getCellSum(Point p) {
        return this.getCellDoubles(p).sum();
    }

    public ArrayList<Double> getCellValues(Point p) {
        return this.mCellValues[p.x][p.y];
    }

    public ArrayList<Double> getCellValues(int col, int row) {
        return this.mCellValues[col][row];
    }

    public double[] getGridAggregates() {
        return this.getGridAggregates(this.mCellAggregate);
    }

    public double[] getGridAggregates(CellAggregate cellAggregate) {
        Dimension dimension = new Dimension(this.mWidth, this.mHeight);
        double[] values = new double[this.mWidth * this.mHeight];
        for (int x = 0; x < this.mWidth; ++x) {
            block9: for (int y = 0; y < this.mHeight; ++y) {
                int valueIndex = MathHelper.pointToIndex((Point)new Point(x, y), (Dimension)dimension);
                Point cellPoint = new Point(x, this.mHeight - 1 - y);
                switch (cellAggregate) {
                    case AVG: {
                        values[valueIndex] = this.getCellAverage(cellPoint);
                        continue block9;
                    }
                    case COUNT: {
                        values[valueIndex] = this.getCellCount(cellPoint);
                        continue block9;
                    }
                    case MAX: {
                        values[valueIndex] = this.getCellMax(cellPoint);
                        continue block9;
                    }
                    case MEDIAN: {
                        values[valueIndex] = this.getCellMedian(cellPoint);
                        continue block9;
                    }
                    case MIN: {
                        values[valueIndex] = this.getCellMin(cellPoint);
                        continue block9;
                    }
                    case SUM: {
                        values[valueIndex] = this.getCellSum(cellPoint);
                        continue block9;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }
        return values;
    }

    public BufferWrapper getGridWrapperAverages() {
        Dimension dimension = new Dimension(this.mWidth, this.mHeight);
        double[] values = new double[this.mWidth * this.mHeight];
        for (int x = 0; x < this.mWidth; ++x) {
            for (int y = 0; y < this.mHeight; ++y) {
                values[MathHelper.pointToIndex((Point)new Point((int)x, (int)y), (Dimension)dimension)] = this.getCellAverage(new Point(x, this.mHeight - 1 - y));
            }
        }
        BufferWrapper buffer = new BufferFactory.DoubleBufferFactory().newBuffer(values.length);
        buffer.putDouble(0, values, 0, values.length);
        return buffer;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public MLatLonBox getLatLonBox() {
        return this.mLatLonBox;
    }

    public double getMax() {
        return this.mMax;
    }

    public double getMin() {
        return this.mMin;
    }

    public ArrayList<GridValue> getValues() {
        return this.mValues;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void setCellAggregate(CellAggregate cellAggregate) {
        this.mCellAggregate = cellAggregate;
    }

    public void setLatLonBox(MLatLonBox latLonBox) {
        this.mLatLonBox = latLonBox;
    }

    public void setMax(double max) {
        this.mMax = max;
    }

    public void setMin(double min) {
        this.mMin = min;
    }

    public void setValues(ArrayList<GridValue> values) {
        this.mValues = values;
        for (GridValue value : values) {
            Point p = this.getCellPoint(value.getLatLon());
            this.getCellValues(p).add(value.getValue());
        }
    }

    private DoubleStream getCellDoubles(Point p) {
        return this.getCellValues(p).stream().mapToDouble(Double::doubleValue);
    }

    private Point getCellPoint(MLatLon latLon) {
        double deltaLat = latLon.getLatitude() - this.mLatLonBox.getSouthWest().getLatitude();
        double deltaLon = latLon.getLongitude() - this.mLatLonBox.getSouthWest().getLongitude();
        int xRaw = (int)(deltaLon / (this.mLatLonBox.getLongitudeSpan() / (double)this.mWidth));
        int yRaw = (int)(deltaLat / (this.mLatLonBox.getLatitudeSpan() / (double)this.mHeight));
        int xMax = Math.min(xRaw, this.mWidth - 1);
        int yMax = Math.min(yRaw, this.mHeight - 1);
        int x = Math.max(xMax, 0);
        int y = Math.max(yMax, 0);
        return new Point(x, y);
    }
}

