/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.api.worldwind;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.AbstractSurfaceObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import gov.nasa.worldwind.util.WWMath;
import java.awt.Color;
import java.awt.Point;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.mapton.worldwind.api.worldwind.AnalyticSurfaceAttributes;

public class AnalyticSurface
implements Renderable,
PreRenderable {
    protected static final double DEFAULT_ALTITUDE = 0.0;
    protected static final int DEFAULT_ALTITUDE_MODE = 0;
    protected static final int DEFAULT_DIMENSION = 10;
    protected static final double DEFAULT_VALUE = 0.0;
    protected static final Color DEFAULT_COLOR = Color.BLACK;
    protected static final GridPointAttributes DEFAULT_GRID_POINT_ATTRIBUTES = AnalyticSurface.createGridPointAttributes(0.0, DEFAULT_COLOR);
    protected static final long RELATIVE_TO_GROUND_REGEN_PERIOD = 2000L;
    protected boolean visible = true;
    protected Sector sector;
    protected double altitude;
    protected int altitudeMode = 0;
    protected int width;
    protected int height;
    protected Iterable<? extends GridPointAttributes> values;
    protected double verticalScale = 1.0;
    protected AnalyticSurfaceAttributes surfaceAttributes = new AnalyticSurfaceAttributes();
    protected Object pickObject;
    protected Layer clientLayer;
    protected double[] extremeValues;
    protected boolean expired = true;
    protected boolean updateFailed;
    protected Object globeStateKey;
    protected long regenTime;
    protected Position referencePos;
    protected Vec4 referencePoint;
    protected RenderInfo surfaceRenderInfo;
    protected AnalyticSurfaceObject clampToGroundSurface;
    protected AnalyticSurfaceObject shadowSurface;
    protected final PickSupport pickSupport = new PickSupport();

    public AnalyticSurface(Sector sector, double altitude, int width, int height, Iterable<? extends GridPointAttributes> iterable) {
        if (sector == null) {
            String message = Logging.getMessage((String)"nullValue.SectorIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        if (width <= 0) {
            String message = Logging.getMessage((String)"generic.InvalidWidth", (Object[])new Object[]{width});
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        if (height <= 0) {
            String message = Logging.getMessage((String)"generic.InvalidHeight", (Object[])new Object[]{height});
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        if (iterable == null) {
            String message = Logging.getMessage((String)"nullValue.IterableIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        this.sector = sector;
        this.altitude = altitude;
        this.width = width;
        this.height = height;
        this.values = iterable;
        this.setExpired(true);
    }

    public AnalyticSurface(Sector sector, double altitude, int width, int height) {
        this(sector, altitude, width, height, AnalyticSurface.createDefaultValues(width * height));
    }

    public AnalyticSurface(Sector sector, double altitude) {
        this(sector, altitude, 10, 10);
    }

    public AnalyticSurface(int width, int height) {
        this(Sector.EMPTY_SECTOR, 0.0, width, height);
    }

    public AnalyticSurface() {
        this(10, 10);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Sector getSector() {
        return this.sector;
    }

    public void setSector(Sector sector) {
        if (sector == null) {
            String message = Logging.getMessage((String)"nullValue.SectorIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        this.sector = sector;
        this.setExpired(true);
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
        this.setExpired(true);
    }

    public int getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(int altitudeMode) {
        this.altitudeMode = altitudeMode;
        this.setExpired(true);
    }

    public int[] getDimensions() {
        return new int[]{this.width, this.height};
    }

    public void setDimensions(int width, int height) {
        if (width <= 0) {
            String message = Logging.getMessage((String)"Geom.WidthInvalid", (Object[])new Object[]{width});
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        if (height <= 0) {
            String message = Logging.getMessage((String)"Geom.HeightInvalid", (Object[])new Object[]{height});
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        this.width = width;
        this.height = height;
        this.setExpired(true);
    }

    public Iterable<? extends GridPointAttributes> getValues() {
        return this.values;
    }

    public void setValues(Iterable<? extends GridPointAttributes> iterable) {
        if (iterable == null) {
            String message = Logging.getMessage((String)"nullValue.IterableIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        this.values = iterable;
        this.extremeValues = AnalyticSurface.computeExtremeValues(iterable);
        this.setExpired(true);
    }

    public double getVerticalScale() {
        return this.verticalScale;
    }

    public void setVerticalScale(double scale) {
        this.verticalScale = scale;
        this.setExpired(true);
    }

    public AnalyticSurfaceAttributes getSurfaceAttributes() {
        return this.surfaceAttributes.copy();
    }

    public void setSurfaceAttributes(AnalyticSurfaceAttributes attributes) {
        if (attributes == null) {
            String message = Logging.getMessage((String)"nullValue.AttributesIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        this.surfaceAttributes = attributes.copy();
        this.setExpired(true);
    }

    public Object getPickObject() {
        return this.pickObject;
    }

    public void setPickObject(Object pickObject) {
        this.pickObject = pickObject;
    }

    public Layer getClientLayer() {
        return this.clientLayer;
    }

    public void setClientLayer(Layer layer) {
        this.clientLayer = layer;
    }

    public void preRender(DrawContext dc) {
        if (dc == null) {
            String message = Logging.getMessage((String)"nullValue.DrawContextIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        if (!this.isVisible()) {
            return;
        }
        if (!this.intersectsFrustum(dc)) {
            return;
        }
        if (this.isExpired(dc)) {
            this.update(dc);
        }
        if (this.isExpired(dc)) {
            return;
        }
        this.preRenderSurfaceObjects(dc);
    }

    public void render(DrawContext dc) {
        if (dc == null) {
            String message = Logging.getMessage((String)"nullValue.DrawContextIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        if (!this.isVisible()) {
            return;
        }
        if (!this.intersectsFrustum(dc)) {
            return;
        }
        if (this.isExpired(dc)) {
            this.update(dc);
        }
        if (this.isExpired(dc)) {
            return;
        }
        this.makeOrderedRenderable(dc);
        this.drawSurfaceObjects(dc);
    }

    public Extent getExtent(DrawContext dc) {
        if (dc == null) {
            String message = Logging.getMessage((String)"nullValue.DrawContextIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        if (this.getAltitudeMode() == 1) {
            return Sector.computeBoundingBox((Globe)dc.getGlobe(), (double)dc.getVerticalExaggeration(), (Sector)this.getSector());
        }
        double minAltitude = this.getAltitude();
        double maxAltitude = this.getAltitude();
        double[] minAndMaxElevations = dc.getGlobe().getMinAndMaxElevations(this.getSector());
        if (this.extremeValues != null) {
            minAltitude = this.getAltitude() + this.getVerticalScale() * this.extremeValues[0];
            maxAltitude = this.getAltitude() + this.getVerticalScale() * this.extremeValues[1];
        }
        if (minAndMaxElevations != null) {
            if (this.getAltitudeMode() == 2) {
                minAltitude -= minAndMaxElevations[0];
                maxAltitude += minAndMaxElevations[1];
            }
            if (minAltitude > minAndMaxElevations[0]) {
                minAltitude = minAndMaxElevations[0];
            }
            if (maxAltitude < minAndMaxElevations[1]) {
                maxAltitude = minAndMaxElevations[1];
            }
        }
        return Sector.computeBoundingBox((Globe)dc.getGlobe(), (double)dc.getVerticalExaggeration(), (Sector)this.getSector(), (double)minAltitude, (double)maxAltitude);
    }

    protected boolean intersectsFrustum(DrawContext dc) {
        Extent extent = this.getExtent(dc);
        if (extent == null) {
            return false;
        }
        if (dc.isPickingMode()) {
            return dc.getPickFrustums().intersectsAny(extent);
        }
        return dc.getView().getFrustumInModelCoordinates().intersects(extent);
    }

    public static double[] computeExtremeValues(Iterable<? extends GridPointAttributes> iterable, double missingDataSignal) {
        if (iterable == null) {
            String message = Logging.getMessage((String)"nullValue.IterableIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        double minValue = Double.MAX_VALUE;
        double maxValue = -1.7976931348623157E308;
        for (GridPointAttributes gridPointAttributes : iterable) {
            double value = gridPointAttributes.getValue();
            if (Double.compare(value, missingDataSignal) == 0) continue;
            if (minValue > value) {
                minValue = value;
            }
            if (!(maxValue < value)) continue;
            maxValue = value;
        }
        if (minValue == Double.MAX_VALUE || minValue == -4.9E-324) {
            return null;
        }
        return new double[]{minValue, maxValue};
    }

    public static double[] computeExtremeValues(Iterable<? extends GridPointAttributes> iterable) {
        if (iterable == null) {
            String message = Logging.getMessage((String)"nullValue.IterableIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        return AnalyticSurface.computeExtremeValues(iterable, Double.NaN);
    }

    public static GridPointAttributes createGridPointAttributes(final double value, final Color color) {
        return new GridPointAttributes(){

            @Override
            public double getValue() {
                return value;
            }

            @Override
            public Color getColor() {
                return color;
            }
        };
    }

    public static GridPointAttributes createColorGradientAttributes(double value, double minValue, double maxValue, double minHue, double maxHue) {
        double hueFactor = WWMath.computeInterpolationFactor((double)value, (double)minValue, (double)maxValue);
        Color color = Color.getHSBColor((float)WWMath.mixSmooth((double)hueFactor, (double)minHue, (double)maxHue), 1.0f, 1.0f);
        double opacity = WWMath.computeInterpolationFactor((double)value, (double)minValue, (double)(minValue + (maxValue - minValue) * 0.1));
        Color rgbaColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * opacity));
        return AnalyticSurface.createGridPointAttributes(value, rgbaColor);
    }

    public static Iterable<? extends GridPointAttributes> createDefaultValues(int count) {
        ArrayList list = new ArrayList(count);
        Collections.fill(list, DEFAULT_GRID_POINT_ATTRIBUTES);
        return list;
    }

    public static Iterable<? extends GridPointAttributes> createColorGradientValues(BufferWrapper values, double missingDataSignal, double minValue, double maxValue, double minHue, double maxHue) {
        if (values == null) {
            String message = Logging.getMessage((String)"nullValue.BufferIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        ArrayList<GridPointAttributes> attributesList = new ArrayList<GridPointAttributes>();
        for (int i = 0; i < values.length(); ++i) {
            double value = values.getDouble(i);
            if (Double.compare(value, missingDataSignal) == 0) {
                value = minValue;
            }
            attributesList.add(AnalyticSurface.createColorGradientAttributes(value, minValue, maxValue, minHue, maxHue));
        }
        return attributesList;
    }

    protected void makeOrderedRenderable(DrawContext dc) {
        if (this.getAltitudeMode() == 1) {
            return;
        }
        Extent extent = this.getExtent(dc);
        double eyeDistance = dc.getView().getEyePoint().distanceTo3(extent.getCenter()) - extent.getRadius();
        if (eyeDistance < 1.0) {
            eyeDistance = 1.0;
        }
        dc.addOrderedRenderable((OrderedRenderable)new OrderedSurface(this, eyeDistance));
    }

    protected void drawOrderedRenderable(DrawContext dc) {
        this.beginDrawing(dc);
        try {
            this.doDrawOrderedRenderable(dc);
        }
        finally {
            this.endDrawing(dc);
        }
    }

    protected void doDrawOrderedRenderable(DrawContext dc) {
        this.bind(dc);
        if (this.surfaceAttributes.isDrawOutline() && this.surfaceAttributes.isDrawInterior()) {
            dc.getGL().glDepthMask(false);
            this.drawOutline(dc);
            dc.getGL().glDepthMask(true);
        }
        if (this.surfaceAttributes.isDrawInterior()) {
            this.drawInterior(dc);
        }
        if (this.surfaceAttributes.isDrawOutline()) {
            this.drawOutline(dc);
        }
    }

    protected void bind(DrawContext dc) {
        GL2 gl = dc.getGL().getGL2();
        gl.glEnableClientState(32884);
        gl.glVertexPointer(3, 5126, 0, (Buffer)this.surfaceRenderInfo.cartesianVertexBuffer);
        if (!dc.isPickingMode()) {
            gl.glEnableClientState(32885);
            gl.glNormalPointer(5126, 0, (Buffer)this.surfaceRenderInfo.cartesianNormalBuffer);
            gl.glEnableClientState(32886);
            gl.glColorPointer(4, 5121, 0, (Buffer)this.surfaceRenderInfo.colorBuffer);
        }
    }

    protected void drawInterior(DrawContext dc) {
        GL2 gl = dc.getGL().getGL2();
        if (!dc.isPickingMode()) {
            gl.glEnable(2903);
            gl.glColorMaterial(1032, 4609);
            this.surfaceAttributes.getInteriorMaterial().apply(gl, 1032, (float)this.surfaceAttributes.getInteriorOpacity());
        }
        gl.glCullFace(1028);
        this.surfaceRenderInfo.drawInterior(dc);
        gl.glCullFace(1029);
        this.surfaceRenderInfo.drawInterior(dc);
    }

    protected void drawOutline(DrawContext dc) {
        GL2 gl = dc.getGL().getGL2();
        if (!dc.isPickingMode()) {
            gl.glEnable(2848);
            gl.glDisable(2896);
            gl.glDisable(2903);
            Color color = this.surfaceAttributes.getOutlineMaterial().getDiffuse();
            int alpha = (int)(255.0 * this.surfaceAttributes.getOutlineOpacity() + 0.5);
            gl.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)alpha);
            gl.glDisableClientState(32886);
        }
        gl.glLineWidth((float)this.surfaceAttributes.getOutlineWidth());
        this.surfaceRenderInfo.drawOutline(dc);
        if (!dc.isPickingMode()) {
            gl.glEnable(2896);
            gl.glDisable(2848);
            gl.glDisable(2852);
            gl.glEnableClientState(32886);
        }
    }

    protected void beginDrawing(DrawContext dc) {
        GL2 gl = dc.getGL().getGL2();
        gl.glPushAttrib(0x410D | (!dc.isPickingMode() ? 64 : 0) | (!dc.isPickingMode() ? 4096 : 0));
        gl.glEnable(3008);
        gl.glAlphaFunc(516, 0.0f);
        gl.glEnable(2884);
        if (dc.isPickingMode()) {
            Color color = dc.getUniquePickColor();
            this.pickSupport.addPickableObject(color.getRGB(), this.getPickObject() != null ? this.getPickObject() : this, new Position(this.sector.getCentroid(), this.altitude), false);
            gl.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        } else {
            gl.glEnable(3042);
            OGLUtil.applyBlending((GL2)gl, (boolean)false);
            gl.glDisable(2903);
            gl.glDisable(16384);
            gl.glEnable(2896);
            gl.glEnable(16385);
            gl.glEnable(2977);
            gl.glLightModeli(2897, 1);
            gl.glLightModeli(2898, 1);
            gl.glShadeModel(7425);
            OGLUtil.applyLightingDirectionalFromViewer((GL2)gl, (int)16385, (Vec4)new Vec4(1.0, 0.5, 1.0).normalize3());
        }
        dc.getView().pushReferenceCenter(dc, this.referencePoint);
    }

    protected void endDrawing(DrawContext dc) {
        GL2 gl = dc.getGL().getGL2();
        dc.getView().popReferenceCenter(dc);
        gl.glPopAttrib();
        gl.glDisableClientState(32884);
        gl.glDisableClientState(32886);
        gl.glDisableClientState(32885);
    }

    protected boolean isExpired(DrawContext dc) {
        if (this.expired) {
            return true;
        }
        if (this.getAltitudeMode() == 2 && dc.getFrameTimeStamp() - this.regenTime > 2000L) {
            return true;
        }
        if (this.getAltitudeMode() == 2 || this.getAltitudeMode() == 0) {
            Object gsk = dc.getGlobe().getStateKey(dc);
            if (this.globeStateKey != null ? !this.globeStateKey.equals(gsk) : gsk != null) {
                return true;
            }
        }
        return false;
    }

    protected void setExpired(boolean expired) {
        this.expired = expired;
        if (this.expired) {
            if (this.clampToGroundSurface != null) {
                this.clampToGroundSurface.markAsModified();
            }
            if (this.shadowSurface != null) {
                this.shadowSurface.markAsModified();
            }
        }
    }

    protected void update(DrawContext dc) {
        if (this.updateFailed) {
            return;
        }
        try {
            this.doUpdate(dc);
            this.setExpired(false);
            this.globeStateKey = dc.getGlobe().getStateKey(dc);
            this.regenTime = dc.getFrameTimeStamp();
        }
        catch (Exception e) {
            String message = Logging.getMessage((String)"generic.ExceptionWhileUpdating", (Object[])new Object[]{this});
            Logging.logger().log(Level.SEVERE, message, e);
            this.updateFailed = true;
        }
    }

    protected void doUpdate(DrawContext dc) {
        this.referencePos = new Position(this.sector.getCentroid(), this.altitude);
        this.referencePoint = dc.getGlobe().computePointFromPosition(this.referencePos);
        if (this.surfaceRenderInfo == null || this.surfaceRenderInfo.getGridWidth() != this.width || this.surfaceRenderInfo.getGridHeight() != this.height) {
            this.surfaceRenderInfo = new RenderInfo(this.width, this.height);
        }
        this.updateSurfacePoints(dc, this.surfaceRenderInfo);
        this.updateSurfaceNormals(this.surfaceRenderInfo);
    }

    protected void updateSurfacePoints(DrawContext dc, RenderInfo outRenderInfo) {
        Iterator<? extends GridPointAttributes> iter = this.values.iterator();
        double latStep = -this.sector.getDeltaLatDegrees() / (double)(this.height - 1);
        double lonStep = this.sector.getDeltaLonDegrees() / (double)(this.width - 1);
        double lat = this.sector.getMaxLatitude().degrees;
        for (int y = 0; y < this.height; ++y) {
            double lon = this.sector.getMinLongitude().degrees;
            for (int x = 0; x < this.width; ++x) {
                GridPointAttributes attr = iter.hasNext() ? iter.next() : null;
                this.updateNextSurfacePoint(dc, Angle.fromDegrees((double)lat), Angle.fromDegrees((double)lon), attr, outRenderInfo);
                lon += lonStep;
            }
            lat += latStep;
        }
        outRenderInfo.cartesianVertexBuffer.rewind();
        outRenderInfo.geographicVertexBuffer.rewind();
        outRenderInfo.colorBuffer.rewind();
        outRenderInfo.shadowColorBuffer.rewind();
    }

    protected void updateNextSurfacePoint(DrawContext dc, Angle lat, Angle lon, GridPointAttributes attr, RenderInfo outRenderInfo) {
        Color color = attr != null ? attr.getColor() : DEFAULT_COLOR;
        int alpha = (int)((double)color.getAlpha() * this.surfaceAttributes.getInteriorOpacity() + 0.5);
        outRenderInfo.colorBuffer.put((byte)color.getRed());
        outRenderInfo.colorBuffer.put((byte)color.getGreen());
        outRenderInfo.colorBuffer.put((byte)color.getBlue());
        outRenderInfo.colorBuffer.put((byte)alpha);
        if (this.getAltitudeMode() == 1 || this.surfaceAttributes.isDrawShadow()) {
            outRenderInfo.geographicVertexBuffer.put((float)(lon.degrees - this.referencePos.getLongitude().degrees));
            outRenderInfo.geographicVertexBuffer.put((float)(lat.degrees - this.referencePos.getLatitude().degrees));
            outRenderInfo.geographicVertexBuffer.put(1.0f);
        }
        if (this.getAltitudeMode() != 1) {
            Vec4 point = this.computeSurfacePoint(dc, lat, lon, attr != null ? attr.getValue() : 0.0);
            outRenderInfo.cartesianVertexBuffer.put((float)(point.x - this.referencePoint.x));
            outRenderInfo.cartesianVertexBuffer.put((float)(point.y - this.referencePoint.y));
            outRenderInfo.cartesianVertexBuffer.put((float)(point.z - this.referencePoint.z));
        }
        if (this.surfaceAttributes.isDrawShadow()) {
            int shadowAlpha = (int)((double)alpha * this.surfaceAttributes.getShadowOpacity() + 0.5);
            outRenderInfo.shadowColorBuffer.put((byte)0);
            outRenderInfo.shadowColorBuffer.put((byte)0);
            outRenderInfo.shadowColorBuffer.put((byte)0);
            outRenderInfo.shadowColorBuffer.put((byte)shadowAlpha);
        }
    }

    protected Vec4 computeSurfacePoint(DrawContext dc, Angle lat, Angle lon, double value) {
        double offset = this.altitude + this.verticalScale * value;
        if (this.getAltitudeMode() == 2) {
            return dc.computeTerrainPoint(lat, lon, dc.getVerticalExaggeration() * offset);
        }
        return dc.getGlobe().computePointFromPosition(lat, lon, offset);
    }

    protected void updateSurfaceNormals(RenderInfo outRenderInfo) {
        WWMath.computeNormalsForIndexedTriangleStrip((IntBuffer)outRenderInfo.interiorIndexBuffer, (FloatBuffer)outRenderInfo.cartesianVertexBuffer, (FloatBuffer)outRenderInfo.cartesianNormalBuffer);
    }

    protected void preRenderSurfaceObjects(DrawContext dc) {
        if (this.surfaceAttributes.isDrawShadow()) {
            if (this.shadowSurface == null) {
                this.shadowSurface = this.createShadowSurface();
            }
            this.shadowSurface.setDelegateOwner(this.getPickObject() != null ? this.getPickObject() : this);
            this.shadowSurface.preRender(dc);
        }
        if (this.getAltitudeMode() == 1) {
            if (this.clampToGroundSurface == null) {
                this.clampToGroundSurface = this.createClampToGroundSurface();
            }
            this.clampToGroundSurface.setDelegateOwner(this.getPickObject() != null ? this.getPickObject() : this);
            this.clampToGroundSurface.preRender(dc);
        }
    }

    protected void drawSurfaceObjects(DrawContext dc) {
        if (this.surfaceAttributes.isDrawShadow() && !dc.isPickingMode() && this.shadowSurface != null) {
            this.shadowSurface.render(dc);
        }
        if (this.getAltitudeMode() == 1) {
            this.clampToGroundSurface.render(dc);
        }
    }

    protected AnalyticSurfaceObject createClampToGroundSurface() {
        return new ClampToGroundSurface(this);
    }

    protected AnalyticSurfaceObject createShadowSurface() {
        return new ShadowSurface(this);
    }

    public static interface GridPointAttributes {
        public double getValue();

        public Color getColor();
    }

    protected static class OrderedSurface
    implements OrderedRenderable {
        protected final AnalyticSurface surface;
        protected final double eyeDistance;

        public OrderedSurface(AnalyticSurface surface, double eyeDistance) {
            this.surface = surface;
            this.eyeDistance = eyeDistance;
        }

        public double getDistanceFromEye() {
            return this.eyeDistance;
        }

        public void pick(DrawContext dc, Point pickPoint) {
            this.surface.pickSupport.beginPicking(dc);
            try {
                this.render(dc);
            }
            finally {
                this.surface.pickSupport.endPicking(dc);
                this.surface.pickSupport.resolvePick(dc, dc.getPickPoint(), this.surface.getClientLayer());
            }
        }

        public void render(DrawContext dc) {
            this.surface.drawOrderedRenderable(dc);
        }
    }

    protected static class RenderInfo {
        protected final int gridWidth;
        protected final int gridHeight;
        protected final IntBuffer interiorIndexBuffer;
        protected final IntBuffer outlineIndexBuffer;
        protected final FloatBuffer cartesianVertexBuffer;
        protected final FloatBuffer cartesianNormalBuffer;
        protected final FloatBuffer geographicVertexBuffer;
        protected final ByteBuffer colorBuffer;
        protected final ByteBuffer shadowColorBuffer;

        public RenderInfo(int gridWidth, int gridHeight) {
            int numVertices = gridWidth * gridHeight;
            this.gridWidth = gridWidth;
            this.gridHeight = gridHeight;
            this.interiorIndexBuffer = WWMath.computeIndicesForGridInterior((int)gridWidth, (int)gridHeight);
            this.outlineIndexBuffer = WWMath.computeIndicesForGridOutline((int)gridWidth, (int)gridHeight);
            this.cartesianVertexBuffer = Buffers.newDirectFloatBuffer((int)(3 * numVertices));
            this.cartesianNormalBuffer = Buffers.newDirectFloatBuffer((int)(3 * numVertices));
            this.geographicVertexBuffer = Buffers.newDirectFloatBuffer((int)(3 * numVertices));
            this.colorBuffer = Buffers.newDirectByteBuffer((int)(4 * numVertices));
            this.shadowColorBuffer = Buffers.newDirectByteBuffer((int)(4 * numVertices));
        }

        public int getGridWidth() {
            return this.gridWidth;
        }

        public int getGridHeight() {
            return this.gridHeight;
        }

        public int getNumVertices() {
            return this.gridWidth * this.gridHeight;
        }

        public void drawInterior(DrawContext dc) {
            GL2 gl = dc.getGL().getGL2();
            gl.glDrawElements(5, this.interiorIndexBuffer.remaining(), 5125, (Buffer)this.interiorIndexBuffer);
        }

        public void drawOutline(DrawContext dc) {
            GL2 gl = dc.getGL().getGL2();
            gl.glDrawElements(2, this.outlineIndexBuffer.remaining(), 5125, (Buffer)this.outlineIndexBuffer);
        }
    }

    protected static class AnalyticSurfaceObject
    extends AbstractSurfaceObject {
        protected AnalyticSurface analyticSurface;

        public AnalyticSurfaceObject(AnalyticSurface analyticSurface) {
            this.analyticSurface = analyticSurface;
        }

        public void markAsModified() {
            super.updateModifiedTime();
            super.clearCaches();
        }

        public List<Sector> getSectors(DrawContext dc) {
            if (dc == null) {
                String message = Logging.getMessage((String)"nullValue.DrawContextIsNull");
                Logging.logger().severe(message);
                throw new IllegalArgumentException(message);
            }
            return Arrays.asList(this.analyticSurface.sector);
        }

        protected void drawGeographic(DrawContext dc, SurfaceTileDrawContext sdc) {
            this.beginDrawing(dc);
            try {
                this.doDrawGeographic(dc, sdc);
            }
            finally {
                this.endDrawing(dc);
            }
        }

        protected void beginDrawing(DrawContext dc) {
            GL2 gl = dc.getGL().getGL2();
            gl.glPushAttrib(16645);
            gl.glMatrixMode(5888);
            gl.glPushMatrix();
            gl.glEnable(3042);
            OGLUtil.applyBlending((GL2)gl, (boolean)false);
            gl.glDisable(2929);
            if (!dc.isPickingMode()) {
                gl.glEnable(2848);
            }
        }

        protected void endDrawing(DrawContext dc) {
            GL2 gl = dc.getGL().getGL2();
            gl.glPopMatrix();
            gl.glPopAttrib();
            gl.glDisableClientState(32884);
            gl.glDisableClientState(32886);
        }

        protected void doDrawGeographic(DrawContext dc, SurfaceTileDrawContext sdc) {
            GL2 gl = dc.getGL().getGL2();
            Matrix modelview = sdc.getModelviewMatrix((LatLon)this.analyticSurface.referencePos);
            gl.glMultMatrixd(modelview.toArray(new double[16], 0, false), 0);
            this.bind(dc);
            if (this.analyticSurface.surfaceAttributes.isDrawInterior()) {
                this.drawInterior(dc);
            }
            if (this.analyticSurface.surfaceAttributes.isDrawOutline()) {
                this.drawOutline(dc);
            }
        }

        protected void bind(DrawContext dc) {
        }

        protected void drawInterior(DrawContext dc) {
            this.analyticSurface.surfaceRenderInfo.drawInterior(dc);
        }

        protected void drawOutline(DrawContext dc) {
            GL2 gl = dc.getGL().getGL2();
            gl.glLineWidth((float)this.analyticSurface.surfaceAttributes.getOutlineWidth());
            this.analyticSurface.surfaceRenderInfo.drawOutline(dc);
        }
    }

    protected static class ClampToGroundSurface
    extends AnalyticSurfaceObject {
        public ClampToGroundSurface(AnalyticSurface analyticSurface) {
            super(analyticSurface);
        }

        @Override
        protected void bind(DrawContext dc) {
            GL2 gl = dc.getGL().getGL2();
            gl.glEnableClientState(32884);
            gl.glVertexPointer(3, 5126, 0, (Buffer)this.analyticSurface.surfaceRenderInfo.geographicVertexBuffer);
            if (!dc.isPickingMode()) {
                gl.glEnableClientState(32886);
                gl.glColorPointer(4, 5121, 0, (Buffer)this.analyticSurface.surfaceRenderInfo.colorBuffer);
            }
        }

        @Override
        protected void drawOutline(DrawContext dc) {
            GL2 gl = dc.getGL().getGL2();
            if (!dc.isPickingMode()) {
                Color color = this.analyticSurface.surfaceAttributes.getOutlineMaterial().getDiffuse();
                int alpha = (int)(255.0 * this.analyticSurface.surfaceAttributes.getOutlineOpacity() + 0.5);
                gl.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)alpha);
                gl.glDisableClientState(32886);
            }
            super.drawOutline(dc);
            if (!dc.isPickingMode()) {
                gl.glEnableClientState(32886);
            }
        }
    }

    protected static class ShadowSurface
    extends AnalyticSurfaceObject {
        public ShadowSurface(AnalyticSurface analyticSurface) {
            super(analyticSurface);
        }

        protected void buildPickRepresentation(DrawContext dc) {
        }

        @Override
        protected void bind(DrawContext dc) {
            GL2 gl = dc.getGL().getGL2();
            gl.glEnableClientState(32884);
            gl.glVertexPointer(3, 5126, 0, (Buffer)this.analyticSurface.surfaceRenderInfo.geographicVertexBuffer);
            if (!dc.isPickingMode()) {
                gl.glEnableClientState(32886);
                gl.glColorPointer(4, 5121, 0, (Buffer)this.analyticSurface.surfaceRenderInfo.shadowColorBuffer);
            }
        }

        @Override
        protected void drawOutline(DrawContext dc) {
            GL2 gl = dc.getGL().getGL2();
            if (!dc.isPickingMode()) {
                int alpha = (int)(255.0 * this.analyticSurface.surfaceAttributes.getOutlineOpacity() * this.analyticSurface.surfaceAttributes.getShadowOpacity() + 0.5);
                gl.glColor4ub((byte)0, (byte)0, (byte)0, (byte)alpha);
                gl.glDisableClientState(32886);
            }
            super.drawOutline(dc);
            if (!dc.isPickingMode()) {
                gl.glEnableClientState(32886);
            }
        }
    }
}

