/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.api.worldwind;

import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ScreenImage;
import gov.nasa.worldwind.render.TextRenderer;
import gov.nasa.worldwind.render.TextRendererCache;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLTextRenderer;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.Format;
import java.util.ArrayList;

public class AnalyticSurfaceLegend
implements Renderable {
    protected static final Font DEFAULT_FONT = Font.decode("Arial-PLAIN-12");
    protected static final Color DEFAULT_COLOR = Color.WHITE;
    protected static final int DEFAULT_WIDTH = 32;
    protected static final int DEFAULT_HEIGHT = 256;
    protected boolean visible = true;
    protected ScreenImage screenImage;
    protected Iterable<? extends Renderable> labels;

    public static AnalyticSurfaceLegend fromColorGradient(int width, int height, double minValue, double maxValue, double minHue, double maxHue, Color borderColor, Iterable<? extends LabelAttributes> labels, LabelAttributes titleLabel) {
        AnalyticSurfaceLegend legend = new AnalyticSurfaceLegend();
        legend.screenImage = new ScreenImage();
        legend.screenImage.setImageSource((Object)legend.createColorGradientLegendImage(width, height, minHue, maxHue, borderColor));
        legend.labels = legend.createColorGradientLegendLabels(width, height, minValue, maxValue, labels, titleLabel);
        return legend;
    }

    public static AnalyticSurfaceLegend fromColorGradient(double minValue, double maxValue, double minHue, double maxHue, Iterable<? extends LabelAttributes> labels, LabelAttributes titleLabel) {
        return AnalyticSurfaceLegend.fromColorGradient(32, 256, minValue, maxValue, minHue, maxHue, DEFAULT_COLOR, labels, titleLabel);
    }

    protected AnalyticSurfaceLegend() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public double getOpacity() {
        return this.screenImage.getOpacity();
    }

    public void setOpacity(double opacity) {
        if (opacity < 0.0 || opacity > 1.0) {
            String message = Logging.getMessage((String)"generic.OpacityOutOfRange", (Object[])new Object[]{opacity});
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        this.screenImage.setOpacity(opacity);
    }

    public Point getScreenLocation(DrawContext dc) {
        return this.screenImage.getScreenLocation(dc);
    }

    public void setScreenLocation(Point point) {
        if (point == null) {
            String message = Logging.getMessage((String)"nullValue.PointIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        this.screenImage.setScreenLocation(point);
    }

    public int getWidth(DrawContext dc) {
        if (dc == null) {
            String message = Logging.getMessage((String)"nullValue.DrawContextIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        return this.screenImage.getImageWidth(dc);
    }

    public int getHeight(DrawContext dc) {
        if (dc == null) {
            String message = Logging.getMessage((String)"nullValue.DrawContextIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        return this.screenImage.getImageHeight(dc);
    }

    public void render(DrawContext dc) {
        if (dc == null) {
            String message = Logging.getMessage((String)"nullValue.DrawContextIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        if (!this.isVisible()) {
            return;
        }
        this.doRender(dc);
    }

    public static Iterable<? extends LabelAttributes> createDefaultColorGradientLabels(double minValue, double maxValue, Format format) {
        if (format == null) {
            String message = Logging.getMessage((String)"nullValue.Format");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        ArrayList<LabelAttributes> labels = new ArrayList<LabelAttributes>();
        int numLabels = 5;
        Font font = Font.decode("Arial-BOLD-12");
        for (int i = 0; i < numLabels; ++i) {
            double value = WWMath.mix((double)((double)i / (double)(numLabels - 1)), (double)minValue, (double)maxValue);
            String text = format.format(value);
            if (WWUtil.isEmpty((Object)text)) continue;
            labels.add(AnalyticSurfaceLegend.createLegendLabelAttributes(value, text, font, Color.WHITE, 5.0, 0.0));
        }
        return labels;
    }

    public static LabelAttributes createDefaultTitle(String text) {
        if (text == null) {
            String message = Logging.getMessage((String)"nullValue.StringIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        Font font = Font.decode("Arial-BOLD-16");
        return AnalyticSurfaceLegend.createLegendLabelAttributes(0.0, text, font, Color.WHITE, 0.0, -20.0);
    }

    public static LabelAttributes createLegendLabelAttributes(final double value, final String text, final Font font, final Color color, final double xOffset, final double yOffset) {
        return new LabelAttributes(){

            @Override
            public double getValue() {
                return value;
            }

            @Override
            public String getText() {
                return text;
            }

            @Override
            public Font getFont() {
                return font;
            }

            @Override
            public Color getColor() {
                return color;
            }

            @Override
            public Point2D getOffset() {
                return new Point2D.Double(xOffset, yOffset);
            }
        };
    }

    protected void doRender(DrawContext dc) {
        this.screenImage.render(dc);
        if (!dc.isPickingMode() && this.labels != null) {
            for (Renderable renderable : this.labels) {
                if (renderable == null) continue;
                renderable.render(dc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawLabel(DrawContext dc, LabelAttributes attr, double x, double y, String halign, String valign) {
        TextRenderer tr;
        Point2D offset;
        Point location;
        String text = attr.getText();
        if (WWUtil.isEmpty((Object)text)) {
            return;
        }
        Font font = attr.getFont();
        if (font == null) {
            font = DEFAULT_FONT;
        }
        Color color = DEFAULT_COLOR;
        if (attr.getColor() != null) {
            color = attr.getColor();
        }
        if ((location = this.getScreenLocation(dc)) != null) {
            x += location.getX() - (double)this.screenImage.getImageWidth(dc) / 2.0;
            y += location.getY() - (double)this.screenImage.getImageHeight(dc) / 2.0;
        }
        if ((offset = attr.getOffset()) != null) {
            x += offset.getX();
            y += offset.getY();
        }
        if ((tr = OGLTextRenderer.getOrCreateTextRenderer((TextRendererCache)dc.getTextRendererCache(), (Font)font)) == null) {
            return;
        }
        Rectangle2D bounds = tr.getBounds(text);
        if (bounds != null) {
            if ("gov.nasa.worldwind.avkey.Center".equals(halign)) {
                x += -(bounds.getWidth() / 2.0);
            }
            if ("gov.nasa.worldwind.avkey.Right".equals(halign)) {
                x += -bounds.getWidth();
            }
            if ("gov.nasa.worldwind.avkey.Center".equals(valign)) {
                y += bounds.getHeight() + bounds.getY();
            }
            if ("gov.nasa.worldwind.avkey.Top".equals(valign)) {
                y += bounds.getHeight();
            }
        }
        Rectangle viewport = dc.getView().getViewport();
        tr.beginRendering(viewport.width, viewport.height);
        try {
            double yInGLCoords = (double)viewport.height - y - 1.0;
            tr.setColor(WWUtil.computeContrastingColor((Color)color));
            tr.draw(text, (int)x - 1, (int)yInGLCoords - 1);
            tr.draw(text, (int)x + 1, (int)yInGLCoords - 1);
            tr.draw(text, (int)x + 1, (int)yInGLCoords + 1);
            tr.draw(text, (int)x - 1, (int)yInGLCoords + 1);
            tr.setColor(color);
            tr.draw(text, (int)x, (int)yInGLCoords);
        }
        finally {
            tr.endRendering();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage createColorGradientLegendImage(int width, int height, double minHue, double maxHue, Color borderColor) {
        BufferedImage image = new BufferedImage(width, height, 6);
        Graphics2D g2d = image.createGraphics();
        try {
            for (int y = 0; y < height; ++y) {
                double hue = WWMath.mix((double)(1.0 - (double)y / (double)(height - 1)), (double)minHue, (double)maxHue);
                g2d.setColor(Color.getHSBColor((float)hue, 1.0f, 1.0f));
                g2d.drawLine(0, y, width - 1, y);
            }
            if (borderColor != null) {
                g2d.setColor(borderColor);
                g2d.drawRect(0, 0, width - 1, height - 1);
            }
        }
        finally {
            g2d.dispose();
        }
        return image;
    }

    protected Iterable<? extends Renderable> createColorGradientLegendLabels(int width, int height, double minValue, double maxValue, Iterable<? extends LabelAttributes> labels, LabelAttributes titleLabel) {
        ArrayList<LabelRenderable> list = new ArrayList<LabelRenderable>();
        if (labels != null) {
            for (LabelAttributes labelAttributes : labels) {
                if (labelAttributes == null) continue;
                double factor = WWMath.computeInterpolationFactor((double)labelAttributes.getValue(), (double)minValue, (double)maxValue);
                double y = (1.0 - factor) * (double)(height - 1);
                list.add(new LabelRenderable(this, labelAttributes, width, y, "gov.nasa.worldwind.avkey.Left", "gov.nasa.worldwind.avkey.Center"));
            }
        }
        if (titleLabel != null) {
            list.add(new LabelRenderable(this, titleLabel, (double)width / 2.0, 0.0, "gov.nasa.worldwind.avkey.Center", "gov.nasa.worldwind.avkey.Bottom"));
        }
        return list;
    }

    public static interface LabelAttributes {
        public double getValue();

        public String getText();

        public Font getFont();

        public Color getColor();

        public Point2D getOffset();
    }

    protected static class LabelRenderable
    implements Renderable {
        protected final OrderedLabel orderedLabel;

        public LabelRenderable(AnalyticSurfaceLegend legend, LabelAttributes attr, double x, double y, String halign, String valign) {
            this.orderedLabel = new OrderedLabel(legend, attr, x, y, halign, valign);
        }

        public void render(DrawContext dc) {
            dc.addOrderedRenderable((OrderedRenderable)this.orderedLabel);
        }
    }

    protected static class OrderedLabel
    implements OrderedRenderable {
        protected final AnalyticSurfaceLegend legend;
        protected final LabelAttributes attr;
        protected final double x;
        protected final double y;
        protected final String halign;
        protected final String valign;

        public OrderedLabel(AnalyticSurfaceLegend legend, LabelAttributes attr, double x, double y, String halign, String valign) {
            this.legend = legend;
            this.attr = attr;
            this.x = x;
            this.y = y;
            this.halign = halign;
            this.valign = valign;
        }

        public double getDistanceFromEye() {
            return 0.0;
        }

        public void render(DrawContext dc) {
            this.legend.drawLabel(dc, this.attr, this.x, this.y, this.halign, this.valign);
        }

        public void pick(DrawContext dc, Point pickPoint) {
        }
    }
}

