/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.api.worldwind;

import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.BasicAirspaceAttributes;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;

public class RandomShapeAttributes {
    protected int attrIndex = -1;
    protected PointPlacemarkAttributes[] pointAttrs;
    protected ShapeAttributes[] shapeAttrs;
    protected AirspaceAttributes[] airspaceAttrs;

    public RandomShapeAttributes() {
        this.initialize();
    }

    protected void initialize() {
        Color[] shapeColors = new Color[]{new Color(255, 9, 84), new Color(255, 133, 0), new Color(255, 198, 0), new Color(79, 213, 33), new Color(7, 152, 249), new Color(193, 83, 220)};
        this.pointAttrs = new PointPlacemarkAttributes[shapeColors.length];
        this.shapeAttrs = new ShapeAttributes[shapeColors.length];
        this.airspaceAttrs = new AirspaceAttributes[shapeColors.length];
        for (int i = 0; i < shapeColors.length; ++i) {
            this.pointAttrs[i] = this.createPointAttributes(shapeColors[i]);
            this.shapeAttrs[i] = this.createShapeAttributes(shapeColors[i]);
            this.airspaceAttrs[i] = this.createAirspaceAttributes(shapeColors[i]);
        }
    }

    public RandomShapeAttributes nextAttributes() {
        ++this.attrIndex;
        return this;
    }

    public PointPlacemarkAttributes asPointAttributes() {
        return this.pointAttrs[this.attrIndex % this.pointAttrs.length];
    }

    public ShapeAttributes asShapeAttributes() {
        return this.shapeAttrs[this.attrIndex % this.shapeAttrs.length];
    }

    public AirspaceAttributes asAirspaceAttributes() {
        return this.airspaceAttrs[this.attrIndex % this.airspaceAttrs.length];
    }

    protected PointPlacemarkAttributes createPointAttributes(Color color) {
        PointPlacemarkAttributes attrs = new PointPlacemarkAttributes();
        attrs.setUsePointAsDefaultImage(true);
        attrs.setLineMaterial(new Material(color));
        attrs.setScale(Double.valueOf(7.0));
        return attrs;
    }

    protected ShapeAttributes createShapeAttributes(Color color) {
        BasicShapeAttributes attrs = new BasicShapeAttributes();
        attrs.setInteriorMaterial(new Material(color));
        attrs.setOutlineMaterial(new Material(WWUtil.makeColorBrighter((Color)color)));
        attrs.setInteriorOpacity(0.5);
        attrs.setOutlineWidth(2.0);
        return attrs;
    }

    protected AirspaceAttributes createAirspaceAttributes(Color color) {
        BasicAirspaceAttributes attrs = new BasicAirspaceAttributes();
        attrs.setInteriorMaterial(new Material(color));
        attrs.setOutlineMaterial(new Material(WWUtil.makeColorBrighter((Color)color)));
        attrs.setInteriorOpacity(0.7);
        attrs.setOutlineWidth(2.0);
        attrs.setDrawOutline(true);
        attrs.setEnableAntialiasing(true);
        attrs.setEnableLighting(true);
        return attrs;
    }
}

