/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.api.worldwind;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class WWExampleUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzipAndSaveToTempFile(String path, String suffix) {
        if (WWUtil.isEmpty((Object)path)) {
            String message = Logging.getMessage((String)"nullValue.PathIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        InputStream stream = null;
        try {
            stream = WWIO.openStream((Object)path);
            ByteBuffer buffer = WWIO.readStreamToBuffer((InputStream)stream);
            File file = WWIO.saveBufferToTempFile((ByteBuffer)buffer, (String)WWIO.getFilename((String)path));
            buffer = WWIO.readZipEntryToBuffer((File)file, null);
            File file2 = WWIO.saveBufferToTempFile((ByteBuffer)buffer, (String)suffix);
            return file2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            WWIO.closeStream((Object)stream, (String)path);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveResourceToTempFile(String path, String suffix) {
        if (WWUtil.isEmpty((Object)path)) {
            String message = Logging.getMessage((String)"nullValue.PathIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        InputStream stream = null;
        try {
            stream = WWIO.openStream((Object)path);
            ByteBuffer buffer = WWIO.readStreamToBuffer((InputStream)stream);
            File file = WWIO.saveBufferToTempFile((ByteBuffer)buffer, (String)suffix);
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            WWIO.closeStream((Object)stream, (String)path);
        }
        return null;
    }

    public static void goTo(WorldWindow wwd, Sector sector) {
        if (wwd == null) {
            String message = Logging.getMessage((String)"nullValue.WorldWindow");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        if (sector == null) {
            String message = Logging.getMessage((String)"nullValue.SectorIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        Box extent = Sector.computeBoundingBox((Globe)wwd.getModel().getGlobe(), (double)wwd.getSceneController().getVerticalExaggeration(), (Sector)sector);
        Angle fov = wwd.getView().getFieldOfView();
        double zoom = extent.getRadius() / fov.cosHalfAngle() / fov.tanHalfAngle();
        wwd.getView().goTo(new Position(sector.getCentroid(), 0.0), zoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] readCommaDelimitedNumbers(String path) {
        ArrayList<Double> list;
        block9: {
            if (WWUtil.isEmpty((Object)path)) {
                String message = Logging.getMessage((String)"nullValue.PathIsNull");
                Logging.logger().severe(message);
                throw new IllegalArgumentException(message);
            }
            list = new ArrayList<Double>();
            InputStream is = null;
            BufferedReader reader = null;
            try {
                String line;
                is = WWIO.openFileOrResourceStream((String)path, null);
                reader = new BufferedReader(new InputStreamReader(is));
                while ((line = reader.readLine()) != null) {
                    for (String token : line.split(",")) {
                        Double d = WWUtil.convertStringToDouble((String)token);
                        list.add(d);
                    }
                }
                WWIO.closeStream((Object)is, (String)path);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block9;
            }
            finally {
                WWIO.closeStream((Object)is, (String)path);
                WWIO.closeStream(reader, (String)path);
            }
            WWIO.closeStream((Object)reader, (String)path);
        }
        double[] array = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = (Double)list.get(i);
        }
        return array;
    }

    public static double[] createRandomGridValues(int width, int height, double min, double max, int numIterations, double smoothness) {
        int numValues = width * height;
        double[] values = new double[numValues];
        for (int i = 0; i < numIterations; ++i) {
            double offset = 1.0 - (double)i / (double)numIterations;
            int x1 = (int)Math.round(Math.random() * (double)(width - 1));
            int x2 = (int)Math.round(Math.random() * (double)(width - 1));
            int y1 = (int)Math.round(Math.random() * (double)(height - 1));
            int y2 = (int)Math.round(Math.random() * (double)(height - 1));
            int dx1 = x2 - x1;
            int dy1 = y2 - y1;
            for (int y = 0; y < height; ++y) {
                int dy2 = y - y1;
                for (int x = 0; x < width; ++x) {
                    int dx2 = x - x1;
                    if (dx2 * dy1 - dx1 * dy2 < 0) continue;
                    int n = x + y * width;
                    values[n] = values[n] + offset;
                }
            }
        }
        WWExampleUtil.scaleValues(values, numValues, min, max);
        return values;
    }

    protected static void scaleValues(double[] values, int count, double minValue, double maxValue) {
        int i;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (i = 0; i < count; ++i) {
            if (min > values[i]) {
                min = values[i];
            }
            if (!(max < values[i])) continue;
            max = values[i];
        }
        for (i = 0; i < count; ++i) {
            values[i] = (values[i] - min) / (max - min);
            values[i] = minValue + values[i] * (maxValue - minValue);
        }
    }

    protected static void smoothValues(int width, int height, double[] values, double smoothness) {
        for (int x = 0; x < width; ++x) {
            WWExampleUtil.smoothBand(values, x, width, height, smoothness);
        }
        int lastRowOffset = (height - 1) * width;
        for (int x = 0; x < width; ++x) {
            WWExampleUtil.smoothBand(values, x + lastRowOffset, -width, height, smoothness);
        }
        for (int y = 0; y < height; ++y) {
            WWExampleUtil.smoothBand(values, y * width, 1, width, smoothness);
        }
        int lastColOffset = width - 1;
        for (int y = 0; y < height; ++y) {
            WWExampleUtil.smoothBand(values, lastColOffset + y * width, -1, width, smoothness);
        }
    }

    protected static void smoothBand(double[] values, int start, int stride, int count, double smoothness) {
        double prevValue = values[start];
        int j = start + stride;
        for (int i = 0; i < count - 1; ++i) {
            values[j] = smoothness * prevValue + (1.0 - smoothness) * values[j];
            prevValue = values[j];
            j += stride;
        }
    }
}

