/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.file_renderer;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.formats.shapefile.ShapefileLayerFactory;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.util.Logging;
import java.util.logging.Level;
import org.mapton.api.MCoordinateFile;
import org.mapton.api.file_opener.ShpCoordinateFileOpener;
import org.mapton.worldwind.api.CoordinateFileRendererWW;
import org.mapton.worldwind.api.LayerBundle;
import org.mapton.worldwind.api.worldwind.RandomShapeAttributes;
import se.trixon.almond.util.swing.SwingHelper;

public class ShpRenderer
extends CoordinateFileRendererWW {
    private final RandomShapeAttributes mRandomShapeAttributes = new RandomShapeAttributes();

    public ShpRenderer() {
        this.addSupportedFileOpeners(ShpCoordinateFileOpener.class);
    }

    @Override
    public void init(LayerBundle layerBundle) {
        this.setLayerBundle(layerBundle);
    }

    @Override
    protected void load(final MCoordinateFile coordinateFile) {
        this.mRandomShapeAttributes.nextAttributes();
        ShapefileLayerFactory shapefileLayerFactory = (ShapefileLayerFactory)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.ShapefileLayerFactory");
        shapefileLayerFactory.setNormalPointAttributes(this.mRandomShapeAttributes.asPointAttributes());
        shapefileLayerFactory.setNormalShapeAttributes(this.mRandomShapeAttributes.asShapeAttributes());
        shapefileLayerFactory.createFromShapefileSource((Object)coordinateFile.getFile(), new ShapefileLayerFactory.CompletionCallback(){

            public void completion(Object result) {
                SwingHelper.runLater(() -> ShpRenderer.this.addLayer(coordinateFile, (Layer)result));
            }

            public void exception(Exception e) {
                Logging.logger().log(Level.SEVERE, e.getMessage(), e);
            }
        });
    }

    @Override
    protected void render() {
        for (MCoordinateFile coordinateFile : this.mCoordinateFileManager.getSublistBySupportedOpeners(this.getSupportedFileOpeners())) {
            this.render(coordinateFile);
        }
    }
}

