/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.ruler;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.util.measure.MeasureTool;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.apache.commons.lang3.StringUtils;
import org.mapton.api.MDict;
import org.mapton.worldwind.ModuleOptions;
import org.mapton.worldwind.ruler.RulerTab;
import org.openide.util.NbBundle;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;

public class OptionsContextMenu
extends ContextMenu {
    private CheckBox mAnnotationCheckBox;
    private ColorPicker mAnnotationColorPicker;
    private ColorPicker mBackgroundColorPicker;
    private final ResourceBundle mBundle = NbBundle.getBundle(RulerTab.class);
    private CheckBox mControlPointsCheckBox;
    private CheckBox mFollowTerrainCheckBox;
    private CheckBox mFreeHandCheckBox;
    private final BiMap<String, CheckBox> mKeyCheckBoxes = HashBiMap.create();
    private ColorPicker mLineColorPicker;
    private Spinner<Double> mLineWidthSpinner;
    private final MeasureTool mMeasureTool;
    private Slider mOpacitySlider;
    private final ModuleOptions mOptions = ModuleOptions.getInstance();
    private ComboBox<String> mPathTypeComboBox;
    private final String[] mPathTypes = new String[]{"gov.nasa.worldwind.avkey.Linear", "gov.nasa.worldwind.avkey.RhumbLine", "gov.nasa.worldwind.avkey.GreatCircle"};
    private ColorPicker mPointColorPicker;
    private CheckBox mPointListCheckBox;
    private CheckBox mRubberBandCheckBox;
    private final SimpleIntegerProperty mShapeIntegerProperty;
    private final WorldWindow mWorldWindow;

    public OptionsContextMenu(MeasureTool measureTool, WorldWindow worldWindow) {
        this.mMeasureTool = measureTool;
        this.mWorldWindow = worldWindow;
        this.mShapeIntegerProperty = new SimpleIntegerProperty();
        this.createUI();
        this.initListeners();
        this.initStates();
    }

    private void createUI() {
        VBox vbox = new VBox(8.0);
        vbox.setPadding(new Insets(8.0, 16.0, 16.0, 16.0));
        Label pathTypeLabel = new Label(this.mBundle.getString("ruler.option.path_type"));
        Object[] pathTypes = StringUtils.split((String)this.mBundle.getString("ruler.option.path_types"), (String)"|");
        this.mPathTypeComboBox = new ComboBox(FXCollections.observableArrayList((Object[])pathTypes));
        this.mPathTypeComboBox.getSelectionModel().select(2);
        this.mLineColorPicker = new ColorPicker();
        this.mBackgroundColorPicker = new ColorPicker();
        this.mPointColorPicker = new ColorPicker();
        this.mAnnotationColorPicker = new ColorPicker();
        this.mOpacitySlider = new Slider(0.0, 1.0, 0.1);
        this.mLineWidthSpinner = new Spinner(1.0, 10.0, 2.0);
        this.mLineWidthSpinner.prefWidthProperty().bind((ObservableValue)this.mLineColorPicker.widthProperty());
        FxHelper.setEditable((boolean)true, (Spinner[])new Spinner[]{this.mLineWidthSpinner});
        FxHelper.autoCommitSpinners((Spinner[])new Spinner[]{this.mLineWidthSpinner});
        this.mFollowTerrainCheckBox = new CheckBox(this.mBundle.getString("ruler.option.follow_terrain"));
        this.mRubberBandCheckBox = new CheckBox(this.mBundle.getString("ruler.option.rubber_band"));
        this.mFreeHandCheckBox = new CheckBox(this.mBundle.getString("ruler.option.free_hand"));
        this.mAnnotationCheckBox = new CheckBox(this.mBundle.getString("ruler.option.annotation"));
        this.mControlPointsCheckBox = new CheckBox(this.mBundle.getString("ruler.option.control_points"));
        this.mPointListCheckBox = new CheckBox(this.mBundle.getString("ruler.option.point_list"));
        this.mFollowTerrainCheckBox.disableProperty().bind((ObservableValue)this.mShapeIntegerProperty.greaterThan(1));
        this.mFreeHandCheckBox.disableProperty().bind((ObservableValue)this.mRubberBandCheckBox.selectedProperty().not().or((ObservableBooleanValue)this.mShapeIntegerProperty.greaterThan(0).and((ObservableBooleanValue)this.mShapeIntegerProperty.lessThan(3)).not()));
        this.mAnnotationCheckBox.disableProperty().bind((ObservableValue)this.mControlPointsCheckBox.selectedProperty().not());
        vbox.getChildren().setAll((Object[])new Node[]{new VBox(new Node[]{new Label(Dict.Geometry.LINE.toString()), this.mLineColorPicker}), new VBox(new Node[]{new Label(MDict.LINE_WIDTH.toString()), this.mLineWidthSpinner}), new VBox(new Node[]{new Label(Dict.BACKGROUND.toString()), this.mBackgroundColorPicker}), new VBox(new Node[]{new Label(Dict.OPACITY.toString()), this.mOpacitySlider}), new VBox(new Node[]{new Label(Dict.Geometry.POINT.toString()), this.mPointColorPicker}), new VBox(new Node[]{new Label(this.mBundle.getString("ruler.option.annotation")), this.mAnnotationColorPicker}), new VBox(new Node[]{pathTypeLabel, this.mPathTypeComboBox}), this.mFollowTerrainCheckBox, this.mRubberBandCheckBox, this.mFreeHandCheckBox, this.mControlPointsCheckBox, this.mAnnotationCheckBox, this.mPointListCheckBox});
        this.mKeyCheckBoxes.put((Object)"ruler.follow_terrain", (Object)this.mFollowTerrainCheckBox);
        this.mKeyCheckBoxes.put((Object)"ruler.rubber_band", (Object)this.mRubberBandCheckBox);
        this.mKeyCheckBoxes.put((Object)"ruler.free_hand", (Object)this.mFreeHandCheckBox);
        this.mKeyCheckBoxes.put((Object)"ruler.annotation", (Object)this.mAnnotationCheckBox);
        this.mKeyCheckBoxes.put((Object)"ruler.control_points", (Object)this.mControlPointsCheckBox);
        this.mKeyCheckBoxes.put((Object)"ruler.point_list", (Object)this.mPointListCheckBox);
        CustomMenuItem customMenuItem = new CustomMenuItem((Node)vbox, false);
        this.getItems().setAll((Object[])new MenuItem[]{customMenuItem});
    }

    private java.awt.Color initColors(ColorPicker colorPicker, String key, Color defaultColor) {
        Color color = FxHelper.colorFromHexRGBA((String)this.mOptions.get(key, new String[]{FxHelper.colorToHexRGBA((Color)defaultColor)}));
        colorPicker.setValue((Object)color);
        return FxHelper.colorToColor((Color)color);
    }

    private void initListeners() {
        this.mOptions.getPreferences().addPreferenceChangeListener(pce -> Platform.runLater(() -> {
            switch (pce.getKey()) {
                case "ruler.shape": {
                    this.mShapeIntegerProperty.set(this.mOptions.getInt("ruler.shape", new Integer[0]));
                }
            }
        }));
        EventHandler eventHandler = actionEvent -> {
            CheckBox checkBox = (CheckBox)actionEvent.getSource();
            String key = (String)this.mKeyCheckBoxes.inverse().get((Object)checkBox);
            boolean selected = checkBox.isSelected();
            this.mOptions.put(key, selected);
            switch (key) {
                case "ruler.control_points": {
                    this.mMeasureTool.setShowControlPoints(selected);
                    break;
                }
                case "ruler.follow_terrain": {
                    this.mMeasureTool.setFollowTerrain(selected);
                    break;
                }
                case "ruler.free_hand": {
                    this.mMeasureTool.getController().setFreeHand(selected);
                    break;
                }
                case "ruler.rubber_band": {
                    this.mMeasureTool.getController().setUseRubberBand(selected);
                    break;
                }
                case "ruler.annotation": {
                    this.mMeasureTool.setShowAnnotation(selected);
                }
            }
            this.mWorldWindow.redraw();
        };
        this.mKeyCheckBoxes.values().forEach(checkBox -> checkBox.setOnAction(eventHandler));
        this.mPathTypeComboBox.setOnAction(event -> {
            int index = this.mPathTypeComboBox.getSelectionModel().getSelectedIndex();
            this.mMeasureTool.setPathType(this.mPathTypes[index]);
            this.mOptions.put("ruler.path_type", index);
        });
        EventHandler colorActionEvent = actionEvent -> {
            ColorPicker source = (ColorPicker)actionEvent.getSource();
            Color color = (Color)source.getValue();
            color = Color.color((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue(), (double)this.mOpacitySlider.getValue());
            java.awt.Color awtColor = FxHelper.colorToColor((Color)color);
            String key = null;
            if (source == this.mLineColorPicker) {
                key = "ruler.color.line";
                this.mMeasureTool.setLineColor(awtColor);
            } else if (source == this.mBackgroundColorPicker) {
                key = "ruler.color.background";
                this.mMeasureTool.setFillColor(awtColor);
            } else if (source == this.mPointColorPicker) {
                key = "ruler.color.point";
                this.mMeasureTool.getControlPointsAttributes().setBackgroundColor(awtColor);
            } else if (source == this.mAnnotationColorPicker) {
                key = "ruler.color.annotation";
                this.mMeasureTool.getAnnotationAttributes().setTextColor(awtColor);
            }
            this.mOptions.put(key, FxHelper.colorToHexRGBA((Color)color));
            this.mWorldWindow.redraw();
        };
        EventHandler colorHiddenEvent = event -> this.setAutoHide(true);
        EventHandler colorShowingEvent = event -> this.setAutoHide(false);
        this.mLineColorPicker.setOnAction(colorActionEvent);
        this.mLineColorPicker.setOnShowing(colorShowingEvent);
        this.mLineColorPicker.setOnHidden(colorHiddenEvent);
        this.mBackgroundColorPicker.setOnAction(colorActionEvent);
        this.mBackgroundColorPicker.setOnShowing(colorShowingEvent);
        this.mBackgroundColorPicker.setOnHidden(colorHiddenEvent);
        this.mPointColorPicker.setOnAction(colorActionEvent);
        this.mPointColorPicker.setOnShowing(colorShowingEvent);
        this.mPointColorPicker.setOnHidden(colorHiddenEvent);
        this.mAnnotationColorPicker.setOnAction(colorActionEvent);
        this.mAnnotationColorPicker.setOnShowing(colorShowingEvent);
        this.mAnnotationColorPicker.setOnHidden(colorHiddenEvent);
        this.mOpacitySlider.valueProperty().addListener((observable, oldValue, newValue) -> {
            double opacity = newValue.doubleValue();
            this.mOptions.put("ruler.opacity", opacity);
            Color color = (Color)this.mBackgroundColorPicker.getValue();
            color = Color.color((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue(), (double)opacity);
            java.awt.Color awtColor = FxHelper.colorToColor((Color)color);
            this.mMeasureTool.setFillColor(awtColor);
        });
        this.mLineWidthSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mMeasureTool.setLineWidth(newValue.doubleValue());
            this.mOptions.put("ruler.line_width", (double)newValue);
        });
    }

    private void initStates() {
        this.mKeyCheckBoxes.values().forEach(checkBox -> checkBox.setSelected(this.mOptions.is((String)this.mKeyCheckBoxes.inverse().get(checkBox), new boolean[0])));
        this.mMeasureTool.setLineColor(this.initColors(this.mLineColorPicker, "ruler.color.line", Color.YELLOW));
        this.mMeasureTool.setFillColor(this.initColors(this.mBackgroundColorPicker, "ruler.color.background", Color.web((String)"FFFF0030")));
        this.mMeasureTool.getControlPointsAttributes().setBackgroundColor(this.initColors(this.mPointColorPicker, "ruler.color.point", Color.BLUE));
        this.mMeasureTool.getAnnotationAttributes().setTextColor(this.initColors(this.mAnnotationColorPicker, "ruler.color.annotation", Color.WHITESMOKE));
        this.mPointListCheckBox.setSelected(this.mOptions.is("ruler.point_list", new boolean[]{false}));
        this.mShapeIntegerProperty.set(this.mOptions.getInt("ruler.shape", new Integer[0]));
        int index = this.mOptions.getInt("ruler.path_type", new Integer[]{1});
        this.mPathTypeComboBox.getSelectionModel().select(index);
        this.mMeasureTool.setPathType(this.mPathTypes[index]);
        double lineWidth = this.mOptions.getDouble("ruler.line_width", new Double[]{3.0});
        this.mLineWidthSpinner.getValueFactory().setValue((Object)lineWidth);
        this.mMeasureTool.setLineWidth(lineWidth);
        double opacity = this.mOptions.getDouble("ruler.opacity", new Double[]{0.1});
        this.mOpacitySlider.setValue(opacity);
    }
}

