/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.ruler;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.measure.MeasureTool;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javafx.geometry.Point2D;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.mapton.api.FileChooserHelper;
import org.mapton.api.MCooTrans;
import org.mapton.api.MKmlCreator;
import org.mapton.api.MOptions;
import org.mapton.worldwind.ruler.RulerTab;
import org.mapton.worldwind.ruler.RulerTabPane;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Exceptions;
import se.trixon.almond.nbp.Almond;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.io.Geo;
import se.trixon.almond.util.io.GeoHeader;
import se.trixon.almond.util.io.GeoLine;
import se.trixon.almond.util.io.GeoPoint;
import se.trixon.almond.util.swing.FileHelper;
import se.trixon.almond.util.swing.SwingHelper;

public class RulerExporter {
    private final FastDateFormat mDateFormat = FastDateFormat.getInstance((String)"yyyyMMdd_HHmmss");
    private final RulerTabPane mRulerTabPane;

    public RulerExporter(RulerTabPane rulerTabPane) {
        this.mRulerTabPane = rulerTabPane;
        SwingHelper.runLater(() -> this.exportFile());
    }

    private void exportFile() {
        String dialogTitle = "%s %s".formatted(Dict.SAVE.toString(), Dict.COORDINATE_FILE.toString().toLowerCase());
        HashMap extensionFilters = FileChooserHelper.getExtensionFilters();
        JFileChooser fileChooser = new FileChooserBuilder(RulerExporter.class).addFileFilter((FileFilter)extensionFilters.get("kml")).addFileFilter((FileFilter)extensionFilters.get("geo")).setAcceptAllFileFilterUsed(false).setDefaultWorkingDirectory(FileHelper.getDefaultDirectory()).setFileFilter((FileFilter)extensionFilters.get("kml")).setFilesOnly(true).setSelectionApprover(FileChooserHelper.getFileExistSelectionApprover((Component)Almond.getFrame())).setTitle(dialogTitle).createFileChooser();
        String epoch = this.mDateFormat.format(new Date());
        File templateFile = new File(Dict.Geometry.GEOMETRIES.toString() + "_" + epoch);
        fileChooser.setSelectedFile(templateFile);
        if (fileChooser.showSaveDialog(Almond.getFrame()) == 0) {
            File file = FileChooserHelper.getFileWithProperExt((JFileChooser)fileChooser);
            new Thread(() -> {
                try {
                    switch (FilenameUtils.getExtension((String)file.getName())) {
                        case "geo": {
                            new ExporterGeo(file, epoch);
                            break;
                        }
                        case "kml": {
                            new ExporterKml(file, epoch);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }, this.getClass().getCanonicalName()).start();
        }
    }

    private class ExporterGeo {
        public ExporterGeo(File file, String epoch) throws IOException {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("Application", "Mapton");
            map.put("Author", SystemHelper.getUserName());
            map.put("Created", epoch);
            Geo geo = new Geo(new GeoHeader(map));
            RulerExporter.this.mRulerTabPane.getTabs().stream().filter(RulerTab.class::isInstance).map(tab -> (RulerTab)((Object)tab)).forEachOrdered(rulerTab -> geo.getLines().add(this.constructLine(rulerTab.getMeasureTool())));
            geo.write(file);
        }

        private GeoLine constructLine(MeasureTool measureTool) {
            return switch (measureTool.getMeasureShapeType()) {
                case "MeasureTool.ShapeLine", "MeasureTool.ShapePath" -> this.generateLine(measureTool.getPositions());
                case "MeasureTool.ShapeEllipse", "MeasureTool.ShapePolygon", "MeasureTool.ShapeSquare", "MeasureTool.ShapeQuad", "MeasureTool.ShapeCircle" -> this.generatePolygon(measureTool.getPositions());
                default -> null;
            };
        }

        private GeoLine generateLine(ArrayList<? extends Position> positions) {
            GeoLine line = new GeoLine();
            MCooTrans cooTrans = MOptions.getInstance().getMapCooTrans();
            for (Position position : positions) {
                GeoPoint point = new GeoPoint();
                Point2D p = cooTrans.fromWgs84(position.getLatitude().degrees, position.getLongitude().degrees);
                point.setX(Double.valueOf(p.getY()));
                point.setY(Double.valueOf(p.getX()));
                point.setZ(Double.valueOf(0.0));
                line.getPoints().add(point);
            }
            return line;
        }

        private GeoLine generatePolygon(ArrayList<? extends Position> positions) {
            GeoLine line = this.generateLine(positions);
            line.setClosedPolygon(true);
            return line;
        }
    }

    private class ExporterKml
    extends MKmlCreator {
        ExporterKml(File file, String epoch) throws IOException {
            this.mDocument.setName("%s_%s".formatted(Dict.Geometry.GEOMETRIES.toString(), epoch));
            RulerExporter.this.mRulerTabPane.getTabs().stream().filter(tab -> tab instanceof RulerTab).forEachOrdered(tab -> this.mDocument.addToFeature(((RulerTab)((Object)tab)).getFeature()));
            this.save(file, true, true);
        }
    }
}

