/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.ruler;

import de.micromata.opengis.kml.v_2_2_0.Feature;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.UnitsFormat;
import gov.nasa.worldwind.util.measure.MeasureTool;
import gov.nasa.worldwind.util.measure.MeasureToolController;
import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Tab;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToolBar;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.mapton.api.MPolygonFilterManager;
import org.mapton.api.Mapton;
import org.mapton.worldwind.ModuleOptions;
import org.mapton.worldwind.ruler.KmlFeatureGenerator;
import org.mapton.worldwind.ruler.OptionsContextMenu;
import org.mapton.worldwind.ruler.RulerExporter;
import org.mapton.worldwind.ruler.RulerTabPane;
import org.mapton.worldwind.ruler.ShapeContextMenu;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.SystemHelperFx;
import se.trixon.almond.util.fx.FxActionCheck;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.icons.material.MaterialIcon;

public class RulerTab
extends Tab {
    static final int DEFAULT_PATH_TYPE_INDEX = 2;
    private BorderPane mBorderPane;
    private Action mCopyAction;
    private ImageView mCopyImageView;
    private final GeometryFactory mGeometryFactory = new GeometryFactory();
    private BorderPane mLowerBorderPane;
    private final MeasureTool mMeasureTool;
    private TextArea mMetricsTextArea;
    private final ModuleOptions mOptions = ModuleOptions.getInstance();
    private Action mOptionsAction;
    private OptionsContextMenu mOptionsContextMenu;
    private ImageView mOptionsImageView;
    private ImageView mPauseImageView;
    private TextArea mPointListTextArea;
    private ImageView mResumeImageView;
    private RunState mRunState;
    private Action mSaveAction;
    private ImageView mSaveImageView;
    private Action mShapeAction;
    private ShapeContextMenu mShapeContextMenu;
    private ImageView mShapeImageView;
    private final UnitsFormat mSmallUnitsFormat = new UnitsFormat("UnitsFormat.Meters", "UnitsFormat.SquareMeters", false);
    private FxActionCheck mStartAction;
    private ImageView mStartImageView;
    private FxActionCheck mStopAction;
    private ImageView mStopImageView;
    private String mStoredWkt;
    private ToolBar mToolBar;
    private VBox mTopBox;
    private final UnitsFormat mUnitsFormat = new UnitsFormat();
    private final WorldWindow mWorldWindow;

    public RulerTab(String title, WorldWindow worldWindow) {
        super(title);
        this.mWorldWindow = worldWindow;
        this.mMeasureTool = new MeasureTool(this.mWorldWindow);
        this.mMeasureTool.setController(new MeasureToolController());
        this.createUI();
        this.initListeners();
        this.postInit();
        this.setRunState(RunState.STARTABLE);
        this.updatePointListVisibility();
    }

    public MeasureTool getMeasureTool() {
        return this.mMeasureTool;
    }

    Feature getFeature() {
        return new KmlFeatureGenerator(this.getText(), this.mMetricsTextArea.getText(), this.mMeasureTool).generate();
    }

    private void copyPointList() {
        SystemHelperFx.copyToClipboard((String)String.join((CharSequence)", ", this.mPointListTextArea.getText().split("\n")));
    }

    private void createUI() {
        this.mStartImageView = MaterialIcon._Av.PLAY_ARROW.getImageView(Mapton.getIconSizeToolBarInt());
        this.mPauseImageView = MaterialIcon._Av.PAUSE_CIRCLE_OUTLINE.getImageView(Mapton.getIconSizeToolBarInt());
        this.mResumeImageView = MaterialIcon._Av.PLAY_CIRCLE_OUTLINE.getImageView(Mapton.getIconSizeToolBarInt());
        this.mStopImageView = MaterialIcon._Av.STOP.getImageView(Mapton.getIconSizeToolBarInt());
        this.mSaveImageView = MaterialIcon._Content.SAVE.getImageView(Mapton.getIconSizeToolBarInt());
        this.mOptionsImageView = MaterialIcon._Action.SETTINGS.getImageView(Mapton.getIconSizeToolBarInt());
        this.mShapeImageView = MaterialIcon._Editor.FORMAT_SHAPES.getImageView(Mapton.getIconSizeToolBarInt());
        this.mCopyImageView = MaterialIcon._Content.CONTENT_COPY.getImageView(Mapton.getIconSizeToolBarInt());
        this.mMetricsTextArea = new TextArea();
        this.mMetricsTextArea.setEditable(false);
        this.mMetricsTextArea.setPrefRowCount(7);
        this.mMetricsTextArea.setFont(Font.font((String)"monospaced", (double)FxHelper.getScaledFontSize()));
        this.mPointListTextArea = new TextArea();
        this.mPointListTextArea.setEditable(false);
        this.mLowerBorderPane = new BorderPane((Node)this.mPointListTextArea);
        this.mTopBox = new VBox(8.0);
        this.mTopBox.setAlignment(Pos.CENTER);
        this.mLowerBorderPane.setTop((Node)this.mTopBox);
        this.mBorderPane = new BorderPane((Node)this.mLowerBorderPane);
        this.setContent((Node)this.mBorderPane);
        this.initToolBar();
        this.mShapeContextMenu = new ShapeContextMenu(this.mMeasureTool);
        this.mOptionsContextMenu = new OptionsContextMenu(this.mMeasureTool, this.mWorldWindow);
    }

    private void initListeners() {
        this.mMeasureTool.addPropertyChangeListener(propertyChangeEvent -> {
            String propertyName = propertyChangeEvent.getPropertyName();
            if (StringUtils.equalsAny((CharSequence)propertyName, (CharSequence[])new CharSequence[]{"MeasureTool.AddPosition", "MeasureTool.RemovePosition", "MeasureTool.ReplacePosition"})) {
                this.updatePoints();
            } else if (propertyName.equals("MeasureTool.Armed")) {
                Cursor cursor = Cursor.getDefaultCursor();
                if (this.mMeasureTool.isArmed()) {
                    cursor = Cursor.getPredefinedCursor(1);
                } else {
                    int shapeIndex = this.mOptions.getInt("ruler.shape", new Integer[0]);
                    if (this.mRunState == RunState.STOPPABLE && shapeIndex != 1 && shapeIndex != 2) {
                        this.setRunState(RunState.STARTABLE);
                    }
                    this.updateMetrics();
                }
                ((Component)this.mWorldWindow).setCursor(cursor);
            } else if (propertyName.equals("MeasureTool.MetricChanged")) {
                this.publishWkt();
            }
            if (propertyName.equals("MeasureTool.MetricChanged")) {
                this.updateMetrics();
            }
        });
        this.mOptions.getPreferences().addPreferenceChangeListener(evt -> Platform.runLater(() -> {
            switch (evt.getKey()) {
                case "ruler.point_list": {
                    this.updatePointListVisibility();
                }
            }
        }));
        this.mShapeContextMenu.shapeIndexProperty().addListener((ov, oldValue, newValue) -> this.setRunState(RunState.STOPPABLE));
        this.setOnClosed(event -> {
            this.mMeasureTool.setArmed(false);
            this.mMeasureTool.clear();
            this.mPointListTextArea.clear();
        });
        this.mPointListTextArea.textProperty().addListener((observable, oldValue, newValue) -> MPolygonFilterManager.getInstance().put(this.getText(), newValue));
    }

    private void initToolBar() {
        this.mShapeAction = new Action(Dict.Geometry.GEOMETRY.toString(), event -> {
            if (this.mShapeContextMenu.isShowing()) {
                this.mShapeContextMenu.hide();
            } else {
                ButtonBase node = FxHelper.getButtonForAction((Action)this.mShapeAction, (ObservableList)this.mToolBar.getItems());
                Bounds bounds = node.getBoundsInLocal();
                Bounds screenBounds = node.localToScreen(bounds);
                this.mShapeContextMenu.show((Node)node, screenBounds.getMinX(), screenBounds.getMaxY());
            }
        });
        this.mShapeAction.setGraphic((Node)this.mShapeImageView);
        this.mStartAction = new FxActionCheck(Dict.START.toString(), event -> this.setRunState(this.mRunState == RunState.STARTABLE ? RunState.STOPPABLE : RunState.RESUMABLE));
        this.mStartAction.setGraphic((Node)this.mStartImageView);
        this.mStopAction = new FxActionCheck(Dict.STOP.toString(), event -> this.setRunState(RunState.STARTABLE));
        this.mStopAction.setGraphic((Node)this.mStopImageView);
        this.mSaveAction = new Action(Dict.SAVE.toString(), event -> new RulerExporter((RulerTabPane)this.getTabPane()));
        this.mSaveAction.setGraphic((Node)this.mSaveImageView);
        this.mCopyAction = new Action(Dict.COPY.toString(), event -> this.copyPointList());
        this.mCopyAction.setGraphic((Node)this.mCopyImageView);
        this.mOptionsAction = new Action(Dict.OPTIONS.toString(), event -> {
            if (this.mOptionsContextMenu.isShowing()) {
                this.mOptionsContextMenu.hide();
            } else {
                ButtonBase node = FxHelper.getButtonForAction((Action)this.mOptionsAction, (ObservableList)this.mToolBar.getItems());
                Bounds bounds = node.getBoundsInLocal();
                Bounds screenBounds = node.localToScreen(bounds);
                this.mOptionsContextMenu.show((Node)node, screenBounds.getMinX(), screenBounds.getMaxY());
            }
        });
        this.mOptionsAction.setGraphic((Node)this.mOptionsImageView);
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.addAll(Arrays.asList(this.mShapeAction, this.mStartAction, this.mStopAction, this.mSaveAction, this.mCopyAction, ActionUtils.ACTION_SPAN, this.mOptionsAction));
        this.mToolBar = ActionUtils.createToolBar(actions, (ActionUtils.ActionTextBehavior)ActionUtils.ActionTextBehavior.HIDE);
        FxHelper.slimToolBar((ToolBar)this.mToolBar);
        FxHelper.adjustButtonWidth((Stream)this.mToolBar.getItems().stream(), (double)((double)Mapton.getIconSizeToolBarInt() * 1.5));
        FxHelper.undecorateButtons((Stream)this.mToolBar.getItems().stream());
        this.mBorderPane.setTop((Node)this.mToolBar);
    }

    private boolean isClosedShape() {
        return this.mOptions.getInt("ruler.shape", new Integer[0]) > 1;
    }

    private void postInit() {
        this.mMeasureTool.setShowControlPoints(this.mOptions.is("ruler.control_points", new boolean[0]));
        this.mMeasureTool.setFollowTerrain(this.mOptions.is("ruler.follow_terrain", new boolean[0]));
        this.mMeasureTool.setShowAnnotation(this.mOptions.is("ruler.annotation", new boolean[0]));
        this.mMeasureTool.getController().setFreeHand(this.mOptions.is("ruler.free_hand", new boolean[0]));
        this.mMeasureTool.getController().setUseRubberBand(this.mOptions.is("ruler.rubber_band", new boolean[0]));
    }

    private void publishWkt() {
        ArrayList positions = this.mMeasureTool.getPositions();
        Coordinate[] coordinates = new Coordinate[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            Position position = (Position)positions.get(i);
            coordinates[i] = new Coordinate(position.longitude.degrees, position.latitude.degrees);
        }
        String wkt = StringUtils.equalsAny((CharSequence)this.mMeasureTool.getMeasureShapeType(), (CharSequence[])new CharSequence[]{"MeasureTool.ShapeLine", "MeasureTool.ShapePath"}) ? this.mGeometryFactory.createLineString(coordinates).toString() : this.mGeometryFactory.createPolygon(coordinates).toString();
        if (!StringUtils.equals((CharSequence)this.mStoredWkt, (CharSequence)wkt)) {
            this.mStoredWkt = wkt;
            Mapton.getGlobalState().put("ruler.wkt", (Object)wkt);
        }
    }

    private void setRunState(RunState runState) {
        Platform.runLater(() -> {
            switch (runState) {
                case STARTABLE: {
                    this.mStartAction.setGraphic((Node)this.mStartImageView);
                    this.mStartAction.setSelected(false);
                    this.mStopAction.setDisabled(true);
                    this.mMeasureTool.setArmed(false);
                    break;
                }
                case RESUMABLE: {
                    this.mMeasureTool.setArmed(!this.mMeasureTool.isArmed());
                    this.mStartAction.setGraphic((Node)(!this.mMeasureTool.isArmed() ? this.mResumeImageView : this.mPauseImageView));
                    this.mStartAction.setSelected(false);
                    break;
                }
                case STOPPABLE: {
                    this.mStartAction.setGraphic((Node)this.mPauseImageView);
                    this.mStartAction.setSelected(false);
                    this.mStopAction.setDisabled(false);
                    this.mMeasureTool.clear();
                    this.mMeasureTool.setArmed(true);
                }
            }
            this.mRunState = runState;
        });
    }

    private void updateMetrics() {
        boolean smallObject;
        double area = this.mMeasureTool.getArea();
        double length = this.mMeasureTool.getLength();
        if (area == -1.0) {
            smallObject = length < 1000.0;
        } else {
            boolean bl = smallObject = area < 1000000.0;
        }
        if (smallObject) {
            if (this.mMeasureTool.getUnitsFormat() != this.mSmallUnitsFormat) {
                this.mMeasureTool.setUnitsFormat(this.mSmallUnitsFormat);
            }
        } else if (this.mMeasureTool.getUnitsFormat() != this.mUnitsFormat) {
            this.mMeasureTool.setUnitsFormat(this.mUnitsFormat);
        }
        double unitLimit = 1000.0;
        String lenghtString = length <= 0.0 ? "-" : (length < unitLimit ? "%,7.1f m".formatted(length) : "%,7.3f km".formatted(length / unitLimit));
        unitLimit = 1000000.0;
        String areaString = area < 0.0 ? "-" : (area < unitLimit ? "%,7.1f m\u00b2".formatted(area) : "%,7.3f km\u00b2".formatted(area / unitLimit));
        double width = this.mMeasureTool.getWidth();
        unitLimit = 1000.0;
        String widthString = width < 0.0 ? "-" : (width < unitLimit ? "%,7.1f m".formatted(width) : "%,7.3f km".formatted(width / unitLimit));
        double height = this.mMeasureTool.getHeight();
        unitLimit = 1000.0;
        String heightString = height < 0.0 ? "-" : (height < unitLimit ? "%,7.1f m".formatted(height) : "%,7.3f km".formatted(height / unitLimit));
        Angle angle = this.mMeasureTool.getOrientation();
        String angleString = angle == null ? "-" : "%,6.2f\u00b0".formatted(angle.degrees);
        Position centerPosition = this.mMeasureTool.getCenterPosition();
        String centerString = centerPosition == null ? "-" : "%,7.4f\u00b0 %,7.4f\u00b0".formatted(centerPosition.getLatitude().degrees, centerPosition.getLongitude().degrees);
        int maxKeyLength = Integer.MIN_VALUE;
        int maxValLength = Integer.MIN_VALUE;
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put(this.isClosedShape() ? Dict.Geometry.PERIMETER.toString() : Dict.Geometry.LENGTH.toString(), lenghtString);
        values.put(Dict.Geometry.AREA.toString(), areaString);
        values.put(Dict.Geometry.BEARING.toString(), angleString);
        values.put(Dict.Geometry.WIDTH.toString(), widthString);
        values.put(Dict.Geometry.HEIGHT.toString(), heightString);
        values.put(Dict.Geometry.CENTER.toString(), centerString);
        for (Map.Entry entry : values.entrySet()) {
            maxKeyLength = Math.max(maxKeyLength, ((String)entry.getKey()).length());
            maxValLength = Math.max(maxValLength, ((String)entry.getValue()).length());
        }
        String separator = " : ";
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : values.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            builder.append(StringUtils.leftPad((String)key, (int)maxKeyLength)).append(separator).append(value).append("\n");
        }
        Platform.runLater(() -> this.mMetricsTextArea.setText(builder.toString()));
    }

    private void updatePointListVisibility() {
        if (this.mOptions.is("ruler.point_list", new boolean[]{false})) {
            this.mLowerBorderPane.setCenter((Node)this.mPointListTextArea);
            this.mTopBox.getChildren().add((Object)this.mMetricsTextArea);
        } else {
            this.mLowerBorderPane.setCenter((Node)this.mMetricsTextArea);
        }
    }

    private void updatePoints() {
        this.mPointListTextArea.clear();
        if (this.mMeasureTool.getPositions() != null) {
            StringBuilder builder = new StringBuilder();
            this.mMeasureTool.getPositions().forEach(pos -> builder.append(String.format(Locale.ENGLISH, "%3.6f %2.6f\n", pos.getLongitude().getDegrees(), pos.getLatitude().getDegrees())));
            Platform.runLater(() -> this.mPointListTextArea.setText(builder.toString()));
        }
    }

    public static enum RunState {
        STARTABLE,
        RESUMABLE,
        STOPPABLE;

    }
}

