/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.ruler;

import gov.nasa.worldwind.util.measure.MeasureTool;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.event.EventHandler;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.ToggleGroup;
import org.mapton.worldwind.ModuleOptions;
import se.trixon.almond.util.Dict;

public class ShapeContextMenu
extends ContextMenu {
    private final MeasureTool mMeasureTool;
    private final ModuleOptions mOptions = ModuleOptions.getInstance();
    private final SimpleIntegerProperty mShapeIndexProperty = new SimpleIntegerProperty();

    public ShapeContextMenu(MeasureTool measureTool) {
        this.mMeasureTool = measureTool;
        this.createUI();
    }

    public SimpleIntegerProperty shapeIndexProperty() {
        return this.mShapeIndexProperty;
    }

    private void createUI() {
        String[] shapeTitles = new String[]{Dict.Geometry.LINE.toString(), Dict.Geometry.PATH.toString(), Dict.Geometry.POLYGON.toString(), Dict.Geometry.CIRCLE.toString(), Dict.Geometry.ELLIPSE.toString(), Dict.Geometry.SQUARE.toString(), Dict.Geometry.RECTANGLE.toString()};
        String[] shapes = new String[]{"MeasureTool.ShapeLine", "MeasureTool.ShapePath", "MeasureTool.ShapePolygon", "MeasureTool.ShapeCircle", "MeasureTool.ShapeEllipse", "MeasureTool.ShapeSquare", "MeasureTool.ShapeQuad"};
        Object[] radioButtons = new RadioMenuItem[shapeTitles.length];
        ToggleGroup toggleGroup = new ToggleGroup();
        EventHandler eventHandler = t -> {
            int index = toggleGroup.getToggles().indexOf((Object)toggleGroup.getSelectedToggle());
            this.mMeasureTool.setMeasureShapeType(shapes[index]);
            this.mOptions.put("ruler.shape", index);
            this.mShapeIndexProperty.set(index);
            this.hide();
        };
        for (int i = 0; i < radioButtons.length; ++i) {
            radioButtons[i] = new RadioMenuItem(shapeTitles[i]);
            radioButtons[i].setToggleGroup(toggleGroup);
            radioButtons[i].setOnAction(eventHandler);
        }
        int index = this.mOptions.getInt("ruler.shape", new Integer[0]);
        radioButtons[index].setSelected(true);
        this.mMeasureTool.setMeasureShapeType(shapes[index]);
        MenuItem headerItem = new MenuItem(Dict.Geometry.GEOMETRY.toString());
        headerItem.setDisable(true);
        this.getItems().setAll((Object[])new MenuItem[]{headerItem});
        this.getItems().addAll(radioButtons);
    }
}

