/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.positions.Positions;
import com.github.filosganga.geogson.model.positions.SinglePosition;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.Serializable;

public class GeometryCollection
implements Geometry<Positions>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Iterable<Geometry<?>> geometries;

    private GeometryCollection(Iterable<Geometry<?>> geometries) {
        this.geometries = geometries;
    }

    public static GeometryCollection of(Iterable<Geometry<?>> geometries) {
        return new GeometryCollection(geometries);
    }

    public Iterable<Geometry<?>> getGeometries() {
        return this.geometries;
    }

    @Override
    public Geometry.Type type() {
        return Geometry.Type.GEOMETRY_COLLECTION;
    }

    @Override
    public Positions positions() {
        SinglePosition positions = new SinglePosition(null);
        for (Geometry<?> geometry : this.geometries) {
            positions.merge((Positions)geometry.positions());
        }
        return positions;
    }

    @Override
    public int size() {
        return Iterables.size(this.geometries);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getClass(), this.geometries});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GeometryCollection other = (GeometryCollection)obj;
        return Objects.equal(this.geometries, other.geometries);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("geometries", this.geometries).toString();
    }
}

