/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.AbstractGeometry;
import com.github.filosganga.geogson.model.Coordinates;
import com.github.filosganga.geogson.model.LineString;
import com.github.filosganga.geogson.model.LinearRing;
import com.github.filosganga.geogson.model.MultiPoint;
import com.github.filosganga.geogson.model.Point;
import com.github.filosganga.geogson.model.positions.LinearPositions;
import com.github.filosganga.geogson.model.positions.SinglePosition;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;

public abstract class LinearGeometry
extends AbstractGeometry<LinearPositions> {
    private static final long serialVersionUID = 1L;

    protected LinearGeometry(LinearPositions positions) {
        super(positions);
    }

    public static <T extends LinearGeometry> Function<T, MultiPoint> toMultiPointFn() {
        return new Function<T, MultiPoint>(){

            public MultiPoint apply(T input) {
                return ((LinearGeometry)input).toMultiPoint();
            }
        };
    }

    public static <T extends LinearGeometry> Function<T, LineString> toLineStringFn() {
        return new Function<T, LineString>(){

            public LineString apply(T input) {
                return ((LinearGeometry)input).toLineString();
            }
        };
    }

    public static <T extends LinearGeometry> Function<T, LinearRing> toLinearRingFn() {
        return new Function<T, LinearRing>(){

            public LinearRing apply(T input) {
                return ((LinearGeometry)input).toLinearRing();
            }
        };
    }

    public MultiPoint toMultiPoint() {
        return new MultiPoint((LinearPositions)this.positions());
    }

    public LineString toLineString() {
        return new LineString((LinearPositions)this.positions());
    }

    public LinearRing toLinearRing() {
        return new LinearRing((LinearPositions)this.positions());
    }

    public Iterable<Point> points() {
        return FluentIterable.from(((LinearPositions)this.positions()).children()).transform(SinglePosition.coordinatesFn()).transform((Function)new Function<Coordinates, Point>(){

            public Point apply(Coordinates input) {
                return Point.from(input);
            }
        });
    }
}

