/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.LineString;
import com.github.filosganga.geogson.model.Point;
import com.github.filosganga.geogson.model.positions.LinearPositions;
import com.github.filosganga.geogson.model.positions.SinglePosition;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;

public class LinearRing
extends LineString {
    private static final long serialVersionUID = 1L;

    public LinearRing(LinearPositions positions) {
        super(LinearRing.checkPositions(positions));
        Preconditions.checkArgument((boolean)positions.isClosed());
    }

    private static LinearPositions checkPositions(LinearPositions toCheck) {
        Preconditions.checkArgument((boolean)toCheck.isClosed(), (Object)"LinearRing must be composed by a minimum of 4 points with the first and the last that are the same.");
        return toCheck;
    }

    public static LinearRing of(Point ... points) {
        return LinearRing.of((Iterable<Point>)ImmutableList.copyOf((Collection)Lists.newArrayList((Object[])points)));
    }

    public static LinearRing of(Iterable<Point> points) {
        return new LinearRing(new LinearPositions(Iterables.transform(points, LinearRing.positionsFn(SinglePosition.class))));
    }

    @Override
    public Geometry.Type type() {
        return Geometry.Type.LINEAR_RING;
    }
}

