/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.AbstractGeometry;
import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.LineString;
import com.github.filosganga.geogson.model.Polygon;
import com.github.filosganga.geogson.model.positions.AreaPositions;
import com.github.filosganga.geogson.model.positions.LinearPositions;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;

public class MultiLineString
extends AbstractGeometry<AreaPositions> {
    private static final long serialVersionUID = 1L;

    public MultiLineString(AreaPositions positions) {
        super(positions);
    }

    public static MultiLineString of(LineString ... lineStrings) {
        return MultiLineString.of((Iterable<LineString>)ImmutableList.copyOf((Object[])lineStrings));
    }

    public static MultiLineString of(Iterable<LineString> lineStrings) {
        return new MultiLineString(new AreaPositions(Iterables.transform(lineStrings, MultiLineString.positionsFn(LinearPositions.class))));
    }

    @Override
    public Geometry.Type type() {
        return Geometry.Type.MULTI_LINE_STRING;
    }

    public Polygon toPolygon() {
        return new Polygon((AreaPositions)this.positions());
    }

    public MultiLineString toMultiLineString() {
        return new MultiLineString((AreaPositions)this.positions());
    }

    public Iterable<LineString> lineStrings() {
        return FluentIterable.from(((AreaPositions)this.positions()).children()).transform((Function)new Function<LinearPositions, LineString>(){

            public LineString apply(LinearPositions input) {
                return new LineString(input);
            }
        });
    }
}

