/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.LinearGeometry;
import com.github.filosganga.geogson.model.Point;
import com.github.filosganga.geogson.model.positions.LinearPositions;
import com.github.filosganga.geogson.model.positions.SinglePosition;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;

public class MultiPoint
extends LinearGeometry {
    private static final long serialVersionUID = 1L;

    public MultiPoint(LinearPositions coordinates) {
        super(coordinates);
    }

    public static MultiPoint of(Point ... points) {
        return MultiPoint.of((Iterable<Point>)ImmutableList.copyOf((Object[])points));
    }

    public static MultiPoint of(Iterable<Point> points) {
        return new MultiPoint(new LinearPositions(Iterables.transform(points, MultiPoint.positionsFn(SinglePosition.class))));
    }

    @Override
    public Geometry.Type type() {
        return Geometry.Type.MULTI_POINT;
    }
}

