/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core;

import javafx.geometry.Point2D;
import org.apache.commons.lang3.math.NumberUtils;
import org.mapton.api.MCooTrans;
import org.mapton.api.MLatLon;
import org.mapton.api.MOptions;
import org.mapton.api.Mapton;
import org.mapton.core.cootrans.Wgs84DMS;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.netbeans.spi.quicksearch.SearchRequest;
import org.netbeans.spi.quicksearch.SearchResponse;

public class CoordinateQuickSearchProvider
implements SearchProvider {
    public void evaluate(SearchRequest request, SearchResponse response) {
        MLatLon latLon = this.parseDecimal(request.getText());
        if (latLon == null || !response.addResult(() -> Mapton.getEngine().panTo(latLon), request.getText())) {
            // empty if block
        }
    }

    private MLatLon parseDecimal(String searchString) {
        MLatLon latLon = null;
        String[] coordinate = searchString.replace(",", " ").trim().split("\\s+");
        if (coordinate.length == 2) {
            try {
                Double lat = NumberUtils.createDouble((String)coordinate[0]);
                Double lon = NumberUtils.createDouble((String)coordinate[1]);
                Wgs84DMS dms = new Wgs84DMS();
                if (dms.isWithinWgs84Bounds(lon, lat)) {
                    latLon = new MLatLon(lat.doubleValue(), lon.doubleValue());
                } else {
                    MCooTrans cooTrans = MOptions.getInstance().getMapCooTrans();
                    if (cooTrans.isWithinProjectedBounds(lat.doubleValue(), lon.doubleValue())) {
                        Point2D p = cooTrans.toWgs84(lat.doubleValue(), lon.doubleValue());
                        latLon = new MLatLon(p.getY(), p.getX());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return latLon;
    }
}

