/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.FileChooser;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.SystemUtils;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.mapton.api.MOptions;
import org.mapton.api.Mapton;
import org.mapton.core.api.MaptonNb;
import org.opengis.referencing.FactoryException;
import org.openide.awt.Actions;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;
import se.trixon.almond.nbp.Almond;
import se.trixon.almond.nbp.NbLog;
import se.trixon.almond.nbp.about.AboutAction;
import se.trixon.almond.nbp.dialogs.NbOptionalDialog;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.PrefsHelper;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.fx.AboutModel;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.fx.PopOverWatcher;
import se.trixon.almond.util.fx.dialogs.SimpleDialog;
import se.trixon.almond.util.icons.material.MaterialIcon;
import se.trixon.almond.util.swing.SwingHelper;

public class Initializer
implements Runnable {
    private final MOptions mOptions = MOptions.getInstance();

    @Override
    public void run() {
        System.setProperty("netbeans.winsys.no_help_in_dialogs", "true");
        System.setProperty("netbeans.winsys.no_toolbars", "true");
        boolean fullscreen = this.mOptions.isFullscreen();
        boolean mapOnly = this.mOptions.isMapOnly();
        FxHelper.setDarkThemeEnabled((boolean)this.mOptions.is("ui.laf.dark", new boolean[0]));
        SwingUtilities.invokeLater(() -> {
            javafx.scene.paint.Color iconColor = this.mOptions.getIconColor();
            MaterialIcon.setDefaultColor((javafx.scene.paint.Color)iconColor);
            se.trixon.almond.util.icons.material.swing.MaterialIcon.setDefaultColor((Color)FxHelper.colorToColor((javafx.scene.paint.Color)iconColor));
        });
        try {
            DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
            CRS.decode((String)"EPSG:3007");
        }
        catch (FactoryException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        WindowManager windowManager = WindowManager.getDefault();
        windowManager.invokeWhenUIReady(() -> {
            JFrame frame = (JFrame)windowManager.getMainWindow();
            PopOverWatcher.getInstance().setFrame(frame);
            Almond.setFrame(frame);
            if (SystemUtils.IS_OS_MAC) {
                AboutAction.setFx(true);
                try {
                    String path = "/" + SystemHelper.getPackageAsPath(Initializer.class) + "logo.png";
                    BufferedImage bufferedImage = ImageIO.read(Initializer.class.getResource(path));
                    ImageView imageView = new ImageView((Image)SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null));
                    AboutAction.setAboutModel((se.trixon.almond.util.AboutModel)new AboutModel(SystemHelper.getBundle(Initializer.class, (String)"about"), imageView));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            MaptonNb.progressStart(Dict.WARMING_UP.toString());
            Mapton.getLog().setUseTimestamps(false);
            NbLog.setUseGlobalTag(false);
            Mapton.getLog().setOut(string -> NbLog.i("", string));
            Mapton.getLog().setErr(string -> NbLog.e("", string));
            Mapton.log((String)SystemHelper.getSystemInfo());
            if (fullscreen) {
                Actions.forID((String)"Window", (String)"org.netbeans.core.windows.actions.ToggleFullScreenAction").actionPerformed(null);
            }
            if (mapOnly) {
                windowManager.findTopComponent("MapTopComponent").requestActive();
                Actions.forID((String)"Window", (String)"org.netbeans.core.windows.actions.ShowEditorOnlyAction").actionPerformed(null);
            }
            FxHelper.runLaterDelayed((long)TimeUnit.SECONDS.toMillis(10L), () -> {
                HashMap map = SimpleDialog.getExtensionFilters();
                map.put("*", new FileChooser.ExtensionFilter(Dict.ALL_FILES.toString(), new String[]{"*"}));
                map.put("csv", new FileChooser.ExtensionFilter("Comma-separated value (*.csv)", new String[]{"*.csv"}));
                map.put("geo", new FileChooser.ExtensionFilter("SBG Geo (*.geo)", new String[]{"*.geo"}));
                map.put("json", new FileChooser.ExtensionFilter("JSON (*.json)", new String[]{"*.json"}));
                map.put("kml", new FileChooser.ExtensionFilter("Keyhole Markup Language (*.kml)", new String[]{"*.kml"}));
                map.put("grid", new FileChooser.ExtensionFilter("Mapton Grid (*.grid)", new String[]{"*.grid"}));
                map.put("png", new FileChooser.ExtensionFilter("%s (*.png)".formatted(Dict.IMAGE.toString()), new String[]{"*.png"}));
                map.put("pdf", new FileChooser.ExtensionFilter("Portable Document Format (*.pdf)", new String[]{"*.pdf"}));
            });
            Mapton.getExecutionFlow().executeWhenReady("execution_flow_map_initialized", () -> {
                MaptonNb.progressStop(Dict.WARMING_UP.toString());
                SwingHelper.runLaterDelayed((long)5000L, () -> {
                    Almond.getTopComponent("ReportsTopComponent");
                    Almond.getTopComponent("EditorsTopComponent");
                    Almond.getTopComponent("UpdaterTopComponent");
                    Almond.getTopComponent("PropertiesTopComponent");
                    Almond.getTopComponent("ChartTopComponent");
                    Almond.getTopComponent("BeforeAfterTopComponent");
                    int startCounter = PrefsHelper.inc((Preferences)this.mOptions.getPreferences(), (String)"app.start_counter");
                    if (startCounter == 2 || startCounter % 100 == 0) {
                        Actions.forID((String)"Mapton", (String)"org.mapton.core.actions.AboutMapsAction").actionPerformed(null);
                    }
                });
            });
        });
        Mapton.getGlobalState().addListener(gsce -> Almond.openAndActivateTopComponent((String)gsce.getValue()), new String[]{"map.layer.fastopen_tool"});
        SystemHelper.setDesktopBrowser(url -> {
            try {
                HtmlBrowser.URLDisplayer.getDefault().showURL(new URL((String)url));
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
    }

    static {
        try {
            String key = "laf";
            String defaultLAF = "com.formdev.flatlaf.FlatDarkLaf";
            Preferences preferences = NbPreferences.root().node("laf");
            PrefsHelper.putIfAbsent((Preferences)preferences, (String)key, (String)defaultLAF);
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        NbOptionalDialog.setPreferences(NbPreferences.forModule(NbOptionalDialog.class).node("optionalDialogState"));
    }
}

