/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import org.mapton.api.Mapton;
import org.mapton.core.ui.FxOnScreenDummy;
import org.openide.util.actions.Presenter;
import se.trixon.almond.util.GlobalState;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.swing.SwingHelper;

public final class AppMenuToolBarAction
extends AbstractAction
implements Presenter.Toolbar {
    private final JFXPanel mFxPanel = new JFXPanel();
    private final JPanel mPanel = new JPanel(new BorderLayout());

    public AppMenuToolBarAction() {
        this.init();
        this.initListeners();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public Component getToolbarPresenter() {
        return this.mPanel;
    }

    private void init() {
        if (!Mapton.getThemeColor().equals((Object)Mapton.getDefaultThemeColor())) {
            this.mPanel.setBackground(FxHelper.colorToColor((Color)Mapton.getThemeColor()));
        }
        this.mPanel.add((Component)this.mFxPanel, "East");
        Dimension minDimension = new Dimension(20, 20);
        this.mPanel.setMinimumSize(minDimension);
        this.mPanel.addHierarchyListener(hierarchyEvent -> {
            int height = this.mPanel.getParent().getPreferredSize().height;
            Dimension dimension = new Dimension(height, height);
            this.mPanel.setMaximumSize(dimension);
            this.mPanel.setPreferredSize(dimension);
            this.mPanel.setBackground(this.mPanel.getParent().getBackground());
        });
        SystemHelper.runLaterDelayed((long)500L, () -> Platform.runLater(() -> {
            Scene scene = new Scene((Parent)FxOnScreenDummy.getInstance());
            FxHelper.loadDarkTheme((Scene)scene);
            this.mFxPanel.setScene(scene);
        }));
    }

    private void initListeners() {
        GlobalState globalState = Mapton.getGlobalState();
        globalState.addListener(gsce -> SwingHelper.runLater(() -> this.mPanel.setBackground(FxHelper.colorToColor((Color)Mapton.getThemeColor()))), new String[]{"app_theme_background", "app_theme_foreground"});
    }
}

