/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.mapton.api.FileChooserHelper;
import org.mapton.api.MCoordinateFileOpener;
import org.mapton.core.api.BaseAction;
import org.mapton.core.ui.MapTopComponent;
import org.mapton.core.ui.file_drop_switchboard.FileDropSwitchboard;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import se.trixon.almond.nbp.Almond;
import se.trixon.almond.nbp.dialogs.NbMessage;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.swing.FileHelper;

public final class OpenAction
extends BaseAction {
    private final ResourceBundle mBundle = NbBundle.getBundle(MapTopComponent.class);

    @Override
    public void actionPerformed(ActionEvent e) {
        this.open();
    }

    private void open() {
        TreeMap extToCoordinateFileOpeners = new TreeMap();
        Lookup.getDefault().lookupAll(MCoordinateFileOpener.class).forEach(coordinateFileOpener -> {
            for (String extension : coordinateFileOpener.getExtensions()) {
                extToCoordinateFileOpeners.computeIfAbsent(extension.toLowerCase(Locale.getDefault()), k -> new ArrayList()).add(coordinateFileOpener);
            }
        });
        if (extToCoordinateFileOpeners.isEmpty()) {
            NbMessage.warning(Dict.WARNING.toString(), this.mBundle.getString("no_file_openers"));
        } else {
            TreeSet<FileNameExtensionFilter> fileNameExtensionFilters = new TreeSet<FileNameExtensionFilter>(Comparator.comparing(FileNameExtensionFilter::getDescription));
            JFileChooser fileChooser = new FileChooserBuilder(OpenAction.class).setDefaultWorkingDirectory(FileHelper.getDefaultDirectory()).setFilesOnly(true).setSelectionApprover(FileChooserHelper.getFileExistOpenSelectionApprover((Component)Almond.getFrame())).setTitle(Dict.OPEN.toString()).createFileChooser();
            fileChooser.setMultiSelectionEnabled(true);
            extToCoordinateFileOpeners.entrySet().stream().map(entry -> {
                ((ArrayList)entry.getValue()).sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
                return entry;
            }).forEachOrdered(entry -> ((ArrayList)entry.getValue()).forEach(coordinateFileOpener -> fileNameExtensionFilters.add(new FileNameExtensionFilter("%s (%s)".formatted(coordinateFileOpener.getName(), entry.getKey()), (String)entry.getKey()))));
            for (FileNameExtensionFilter fileNameExtensionFilter : fileNameExtensionFilters) {
                fileChooser.addChoosableFileFilter(fileNameExtensionFilter);
            }
            if (fileChooser.showOpenDialog(Almond.getFrame()) == 0) {
                new FileDropSwitchboard(Arrays.asList(fileChooser.getSelectedFiles()));
            }
        }
    }
}

