/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.Region;
import org.apache.commons.lang3.SystemUtils;
import org.controlsfx.control.PopOver;
import org.controlsfx.control.action.Action;
import org.mapton.api.MOptions;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.fx.PopOverWatcher;

public abstract class BaseToolBar
extends ToolBar {
    public static final int DEFAULT_POP_OVER_WIDTH = 350;
    public static final boolean IS_MAC = SystemUtils.IS_OS_MAC;
    protected final HashSet<PopOver> mAlwaysShowPopOvers = new HashSet();
    protected final MOptions mOptions = MOptions.getInstance();
    protected final HashSet<PopOver> mPopOvers = new HashSet();
    private final HashMap<Action, Double> mButtonWidths = new HashMap();
    private final HashMap<Object, Long> mObjectClosingTimes = new HashMap();

    public void onObjectHiding(Object object) {
        this.mObjectClosingTimes.put(object, System.currentTimeMillis());
    }

    protected ButtonBase getButtonForAction(Action action) {
        return FxHelper.getButtonForAction((Action)action, (ObservableList)this.getItems());
    }

    protected ArrayList<ButtonBase> getButtons() {
        ArrayList<ButtonBase> buttonBases = new ArrayList<ButtonBase>();
        this.getItems().stream().filter(node -> node instanceof ButtonBase).forEachOrdered(buttonbase -> buttonBases.add((ButtonBase)buttonbase));
        return buttonBases;
    }

    protected void initPopOver(PopOver popOver, String title, Node content, boolean alwaysUsePopOver) {
        popOver.setTitle(title);
        popOver.setContentNode(content);
        popOver.setArrowLocation(PopOver.ArrowLocation.TOP_LEFT);
        popOver.setHeaderAlwaysVisible(true);
        popOver.setCloseButtonEnabled(false);
        popOver.setDetachable(false);
        popOver.setAnimated(false);
        popOver.setOnHiding(windowEvent -> this.onObjectHiding(popOver));
        this.mPopOvers.add(popOver);
        if (alwaysUsePopOver) {
            this.mAlwaysShowPopOvers.add(popOver);
        }
    }

    protected void setPopOverWidths(double width, PopOver ... popOvers) {
        for (PopOver popOver : popOvers) {
            ((Region)popOver.getContentNode()).setPrefWidth(width);
        }
    }

    protected void setTextFromActions() {
        for (Map.Entry<Action, Double> entry : this.mButtonWidths.entrySet()) {
            ButtonBase buttonBase = this.getButtonForAction(entry.getKey());
            buttonBase.setPrefWidth(entry.getValue().doubleValue());
            buttonBase.textProperty().bind((ObservableValue)entry.getKey().textProperty());
        }
    }

    protected boolean shouldOpen(Object object) {
        return System.currentTimeMillis() - this.mObjectClosingTimes.getOrDefault(object, 0L) > 200L;
    }

    protected void show(PopOver popOver, Object owner) {
        popOver.show((Node)owner, -6.0);
        PopOverWatcher.getInstance().registerPopOver(popOver, (Node)owner);
    }

    protected void storeButtonWidths(Action ... actions) {
        for (Action action : actions) {
            this.mButtonWidths.put(action, this.getButtonForAction(action).prefWidthProperty().getValue());
        }
    }

    protected void tooglePopOver(PopOver popOver, Action action) {
        FxHelper.runLater(() -> {
            this.getScene().getWindow().requestFocus();
            if (popOver.isAutoHide()) {
                if (popOver.isShowing()) {
                    popOver.hide();
                } else {
                    this.mPopOvers.forEach(item -> item.hide());
                    this.getItems().stream().filter(item -> item instanceof ButtonBase).map(item -> (ButtonBase)item).filter(buttonBase -> buttonBase.getOnAction() == action).forEachOrdered(buttonBase -> buttonBase.fire());
                }
            } else if (popOver.isShowing()) {
                popOver.hide();
            } else {
                this.show(popOver, this.getButtonForAction(action));
            }
        });
    }

    protected boolean usePopOver(PopOver popOver) {
        return this.mOptions.isPreferPopover() || this.mOptions.isMapOnly() || this.mAlwaysShowPopOvers.contains(popOver);
    }
}

