/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.reports;

import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.mapton.api.MApiReport;
import org.mapton.api.MContextMenuItem;
import org.mapton.api.MCooTrans;
import org.mapton.api.MCoordinateFileOpener;
import org.mapton.api.MEngine;
import org.mapton.api.MPoiProvider;
import org.mapton.api.MSimpleObjectStorageBoolean;
import org.mapton.api.MSimpleObjectStorageString;
import org.mapton.api.MToolMapCommand;
import org.mapton.api.MUpdater;
import org.mapton.api.MWhatsHereEngine;
import org.mapton.api.MWmsSourceProvider;
import org.mapton.api.MWmsStyleProvider;
import org.mapton.api.report.MEditor;
import org.mapton.api.report.MReport;
import org.openide.util.Lookup;
import se.trixon.almond.nbp.core.news.NewsProvider;

public class ApiReports
implements MApiReport {
    private final String mCategory = "Core/";
    private final TreeMap<String, TreeSet<String>> mItems = new TreeMap();

    public TreeMap<String, TreeSet<String>> getItems() {
        this.mItems.clear();
        TreeSet<String> copyImplementations = new TreeSet<String>();
        TreeSet<String> extrasImplementations = new TreeSet<String>();
        TreeSet<String> openImplementations = new TreeSet<String>();
        block5: for (MContextMenuItem implementation : Lookup.getDefault().lookupAll(MContextMenuItem.class)) {
            switch (implementation.getType()) {
                case COPY: {
                    copyImplementations.add(implementation.getClass().getCanonicalName());
                    continue block5;
                }
                case EXTRAS: {
                    extrasImplementations.add(implementation.getClass().getCanonicalName());
                    continue block5;
                }
                case OPEN: {
                    openImplementations.add(implementation.getClass().getCanonicalName());
                    continue block5;
                }
            }
            throw new AssertionError();
        }
        this.mItems.put("Core/MContextMenu Copy", copyImplementations);
        this.mItems.put("Core/MContextMenu Extras", extrasImplementations);
        this.mItems.put("Core/MContextMenu Open", openImplementations);
        this.populate(null, MCooTrans.class);
        this.populate(null, MCoordinateFileOpener.class);
        this.populate(null, MEngine.class);
        this.populate(null, MWhatsHereEngine.class);
        this.populate(null, MUpdater.class);
        this.populate(null, MWmsSourceProvider.class);
        this.populate(null, MWmsStyleProvider.class);
        this.populate(null, NewsProvider.class);
        this.populate(null, MPoiProvider.class);
        this.populate(null, MEditor.class);
        this.populate(null, MReport.class);
        this.populate(null, MToolMapCommand.class);
        this.populate(null, MSimpleObjectStorageBoolean.class);
        this.populate("MSimpleObjectStorageString ", MSimpleObjectStorageString.ApiKey.class);
        this.populate("MSimpleObjectStorageString ", MSimpleObjectStorageString.Misc.class);
        this.populate("MSimpleObjectStorageString ", MSimpleObjectStorageString.Path.class);
        this.populate("MSimpleObjectStorageString ", MSimpleObjectStorageString.Url.class);
        return this.mItems;
    }

    private void populate(String prefix, Class clazz) {
        TreeSet<String> implementations = new TreeSet<String>();
        for (Object implementation : Lookup.getDefault().lookupAll(clazz)) {
            implementations.add(implementation.getClass().getCanonicalName());
        }
        this.mItems.put("Core/" + StringUtils.defaultString((String)prefix) + clazz.getSimpleName(), implementations);
    }
}

