/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.status;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.mapton.api.MCooTrans;
import org.mapton.api.MEngine;
import org.mapton.api.MOptions;
import org.mapton.api.Mapton;
import org.openide.awt.StatusLineElementProvider;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.swing.SwingHelper;

public class CoordinateStatusLineElement
implements StatusLineElementProvider {
    private JLabel mLabel;

    public Component getStatusLineElement() {
        if (this.mLabel == null) {
            this.init();
            this.initListeners();
        }
        return this.mLabel;
    }

    private void init() {
        this.mLabel = new JLabel();
        this.mLabel.setFont(new Font("monospaced", 0, this.mLabel.getFont().getSize()));
        this.mLabel.setBorder(new EmptyBorder(0, 0, 0, SwingHelper.getUIScaled((int)8)));
    }

    private void initListeners() {
        Mapton.getGlobalState().addListener(gsce -> this.updateMousePositionData(), new String[]{"Status.Coordinate"});
    }

    private void updateMousePositionData() {
        MEngine engine = Mapton.getEngine();
        if (engine != null) {
            if (engine.getLatitude() != null) {
                double latitude = engine.getLatitude();
                double longitude = engine.getLongitude();
                if (latitude != 0.0 && longitude != 0.0) {
                    String altitude = "";
                    if (engine.getAltitude() != null) {
                        double metersAltitude = engine.getAltitude();
                        altitude = Math.abs(metersAltitude) >= 1000.0 ? "%s %,7d km".formatted(Dict.ALTITUDE.toString(), (int)Math.round(metersAltitude / 1000.0)) : "%s %,7d m".formatted(Dict.ALTITUDE.toString(), (int)Math.round(metersAltitude));
                    }
                    String elevation = "";
                    if (engine.getElevation() != null) {
                        elevation = "%s %,6d %s".formatted(Dict.ELEVATION.toString(), (int)engine.getElevation().doubleValue(), Dict.METERS.toString().toLowerCase());
                    }
                    String text = "";
                    try {
                        text = "%s, %s, %s".formatted(altitude, elevation, MCooTrans.getCooTrans((String)MOptions.getInstance().getMapCooTransName()).getString(latitude, longitude));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.mLabel.setText(StringUtils.removeStart((String)text, (String)", , "));
                }
            } else {
                this.mLabel.setText("");
            }
        }
    }
}

