/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui;

import java.util.Properties;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.BorderPane;
import org.mapton.api.LineChartX;
import org.mapton.api.MChartLine;
import org.mapton.api.MSelectionLockManager;
import org.mapton.api.Mapton;
import org.mapton.core.api.MTopComponent;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.icons.material.MaterialIcon;

@TopComponent.Description(preferredID="ChartTopComponent", persistenceType=0)
public final class ChartTopComponent
extends MTopComponent {
    public ChartTopComponent() {
        this.setName(Dict.CHART.toString());
        this.putClientProperty("print.printable", Boolean.TRUE);
        this.putClientProperty("print.name", "Mapton - %s".formatted(Dict.CHART.toString()));
    }

    @Override
    protected void initFX() {
        this.setScene(new Scene((Parent)new ChartView()));
        Mapton.getGlobalState().put("chart", Mapton.getGlobalState().get("chart"));
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    class ChartView
    extends BorderPane {
        private Label mInvalidPlaceholderLabel;
        private Label mPlaceholderLabel;
        private ProgressBar mProgressBar;

        public ChartView() {
            this.createUI();
            this.initListeners();
        }

        private void createUI() {
            this.mPlaceholderLabel = new Label(NbBundle.getMessage(ChartView.class, (String)"chart_placeholder"), (Node)MaterialIcon._Editor.SHOW_CHART.getImageView(Mapton.getIconSizeToolBar()));
            this.mPlaceholderLabel.setDisable(true);
            this.mInvalidPlaceholderLabel = new Label(NbBundle.getMessage(ChartView.class, (String)"chart_invalid_object"), (Node)MaterialIcon._Editor.SHOW_CHART.getImageView(Mapton.getIconSizeToolBar()));
            this.mInvalidPlaceholderLabel.setDisable(true);
            this.mProgressBar = new ProgressBar(-1.0);
            this.mProgressBar.setPrefWidth(400.0);
            this.setCenter((Node)this.mPlaceholderLabel);
        }

        private void initListeners() {
            Mapton.getGlobalState().addListener(evt -> Platform.runLater(() -> this.refresh(evt.getValue())), new String[]{"chart"});
            Mapton.getGlobalState().addListener(evt -> Platform.runLater(() -> this.setCenter((Node)this.mProgressBar)), new String[]{"chart.wait"});
        }

        private void refresh(Object o) {
            if (MSelectionLockManager.getInstance().isLocked()) {
                return;
            }
            Label centerObject = null;
            if (o == null) {
                centerObject = this.mPlaceholderLabel;
            } else if (o instanceof MChartLine) {
                MChartLine chartLine = (MChartLine)o;
                centerObject = new LineChartX(chartLine).getNode();
            } else if (o instanceof Node) {
                Node node = (Node)o;
                centerObject = node;
            } else {
                centerObject = this.mInvalidPlaceholderLabel;
            }
            this.setCenter((Node)centerObject);
            if (!centerObject.getClass().getPackageName().equals("de.gsi.chart")) {
                FxHelper.loadDarkTheme((Scene)centerObject.getScene());
            }
        }
    }
}

