/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.mapton.api.FileChooserHelper;
import org.mapton.api.MContextMenuItem;
import org.mapton.api.MDict;
import org.mapton.api.MEngine;
import org.mapton.api.MEngineListener;
import org.mapton.api.MOptions;
import org.mapton.api.MWhatsHereEngine;
import org.mapton.api.Mapton;
import org.mapton.core.api.AutoOpener;
import org.mapton.core.api.BookmarkEditor;
import org.mapton.core.ui.FxOnScreenDummy;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import se.trixon.almond.nbp.Almond;
import se.trixon.almond.util.Scaler;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.SystemHelperFx;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.swing.FileHelper;

public class MapContextMenu {
    private final BookmarkEditor mBookmarkEditor;
    private Menu mContextCopyMenu;
    private Menu mContextExtrasMenu;
    private ContextMenu mContextMenu;
    private Menu mContextOpenMenu;
    private final MOptions mMOptions = MOptions.getInstance();

    public MapContextMenu() {
        this.mBookmarkEditor = new BookmarkEditor();
        this.initContextMenu();
        this.initListeners();
    }

    private void copyImage() {
        this.mContextMenu.hide();
        try {
            SystemHelperFx.copyToClipboard((BufferedImage)((BufferedImage)this.getEngine().getImageRenderer().call()));
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void exportImage() {
        FileNameExtensionFilter pngFileNameExtensionFilter = (FileNameExtensionFilter)FileChooserHelper.getExtensionFilters().get("png");
        FileNameExtensionFilter pdfFileNameExtensionFilter = (FileNameExtensionFilter)FileChooserHelper.getExtensionFilters().get("pdf");
        JFileChooser fileChooser = new FileChooserBuilder(MapContextMenu.class).addFileFilter((FileFilter)pngFileNameExtensionFilter).addFileFilter((FileFilter)pdfFileNameExtensionFilter).setDefaultWorkingDirectory(FileHelper.getDefaultDirectory()).setFileFilter((FileFilter)pngFileNameExtensionFilter).setFilesOnly(true).setSelectionApprover(FileChooserHelper.getFileExistSelectionApprover((Component)Almond.getFrame())).setTitle(this.getBundleString("export_view")).createFileChooser();
        File templateFile = new File(FastDateFormat.getInstance((String)"'Mapton_'yyyyMMdd_HHmmss").format(new Date()));
        fileChooser.setSelectedFile(templateFile);
        this.mContextMenu.hide();
        FxHelper.runLaterDelayed((long)10L, () -> {
            if (fileChooser.showSaveDialog(Almond.getFrame()) == 0) {
                new Thread(() -> {
                    File file = FileChooserHelper.getFileWithProperExt((JFileChooser)fileChooser);
                    try {
                        BufferedImage bufferedImage = (BufferedImage)this.getEngine().getImageRenderer().call();
                        if (FilenameUtils.isExtension((String)file.getName(), (String)"png")) {
                            ImageIO.write((RenderedImage)bufferedImage, "png", file);
                        } else {
                            PDDocument doc = new PDDocument();
                            PDRectangle rectangle = PDRectangle.A4;
                            PDPage page = new PDPage(new PDRectangle(rectangle.getHeight(), rectangle.getWidth()));
                            doc.addPage(page);
                            PDImageXObject pdImage = LosslessFactory.createFromImage((PDDocument)doc, (BufferedImage)bufferedImage);
                            try (PDPageContentStream pageContentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, true, true);){
                                Scaler scaler = new Scaler(new Dimension(pdImage.getWidth(), pdImage.getHeight()));
                                int pageHeight = (int)rectangle.getWidth();
                                int pageWidth = (int)rectangle.getHeight();
                                scaler.setHeight(pageHeight);
                                scaler.setWidth(pageWidth);
                                Dimension dim = scaler.getDimension();
                                float width = (float)dim.getWidth();
                                int height = dim.height;
                                float x = ((float)pageWidth - width) / 2.0f;
                                int y = (pageHeight - height) / 2;
                                pageContentStream.drawImage(pdImage, x, (float)y, width, (float)height);
                            }
                            doc.save(file);
                            doc.close();
                        }
                        AutoOpener.openIfActivated(file);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }, this.getClass().getCanonicalName()).start();
            }
        });
    }

    private String getBundleString(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    private MEngine getEngine() {
        return Mapton.getEngine();
    }

    private void initContextMenu() {
        Action setHomeAction = new Action(MDict.SET_HOME.toString(), t -> {
            this.mMOptions.setMapHome(this.getEngine().getCenter());
            this.mMOptions.setMapHomeZoom(this.getEngine().getZoom());
        });
        Action whatsHereAction = new Action(this.getBundleString("whats_here"), t -> this.whatsHere());
        Action copyImageAction = new Action(this.getBundleString("copy_image"), t -> this.copyImage());
        copyImageAction.setDisabled(true);
        Action exportImageAction = new Action(this.getBundleString("export_image"), t -> this.exportImage());
        exportImageAction.setDisabled(true);
        List<Action> actions = Arrays.asList(whatsHereAction, this.mBookmarkEditor.getAddBookmarkAction(), ActionUtils.ACTION_SEPARATOR, copyImageAction, exportImageAction, ActionUtils.ACTION_SEPARATOR, ActionUtils.ACTION_SEPARATOR, setHomeAction);
        this.mContextCopyMenu = new Menu(this.getBundleString("copy_location"));
        this.mContextOpenMenu = new Menu(this.getBundleString("open_location"));
        this.mContextExtrasMenu = new Menu(this.getBundleString("extras"));
        this.mContextMenu = ActionUtils.createContextMenu(actions);
        int insertPos = this.mContextMenu.getItems().size() - 2;
        this.mContextMenu.getItems().add(insertPos, (Object)this.mContextExtrasMenu);
        this.mContextMenu.getItems().add(insertPos, (Object)this.mContextOpenMenu);
        this.mContextMenu.getItems().add(insertPos, (Object)this.mContextCopyMenu);
        this.mContextMenu.setOnShowing(event -> {
            copyImageAction.setDisabled(this.getEngine().getImageRenderer() == null);
            exportImageAction.setDisabled(this.getEngine().getImageRenderer() == null);
        });
        Lookup.getDefault().lookupResult(MContextMenuItem.class).addLookupListener(lookupEvent -> this.populateContextProviders());
        this.populateContextProviders();
    }

    private void initListeners() {
        Mapton.getGlobalState().addListener(gsce -> this.populateContextProviders(), new String[]{"map.populate.context.menu"});
        MEngine.addEngineListener((MEngineListener)new MEngineListener(){

            public void displayContextMenu(Point screenXY) {
                FxOnScreenDummy rootNode = FxOnScreenDummy.getInstance();
                rootNode.getScene().getWindow().requestFocus();
                rootNode.requestFocus();
                MapContextMenu.this.mContextMenu.show((Node)rootNode, (double)screenXY.x, (double)screenXY.y);
            }

            public void hideContextMenu() {
                if (MapContextMenu.this.mContextMenu.isShowing()) {
                    MapContextMenu.this.mContextMenu.hide();
                }
            }
        });
    }

    private void populateContextProviders() {
        Platform.runLater(() -> {
            this.mContextCopyMenu.getItems().clear();
            this.mContextOpenMenu.getItems().clear();
            this.mContextExtrasMenu.getItems().clear();
            ArrayList contextMenues = new ArrayList(Lookup.getDefault().lookupAll(MContextMenuItem.class));
            contextMenues.sort((o1, o2) -> o1.getName().compareTo(o2.getName()));
            block5: for (MContextMenuItem provider : contextMenues) {
                MenuItem menuItem = new MenuItem(provider.getName());
                switch (provider.getType()) {
                    case COPY: {
                        this.mContextCopyMenu.getItems().add((Object)menuItem);
                        menuItem.setOnAction(event -> {
                            String s = provider.getUrl();
                            Mapton.getLog().v("Copy location", s);
                            SystemHelper.copyToClipboard((String)s);
                        });
                        continue block5;
                    }
                    case EXTRAS: {
                        this.mContextExtrasMenu.getItems().add((Object)menuItem);
                        menuItem.setOnAction(provider.getAction());
                        continue block5;
                    }
                    case OPEN: {
                        this.mContextOpenMenu.getItems().add((Object)menuItem);
                        menuItem.setOnAction(event -> {
                            String s = provider.getUrl();
                            if (!StringUtils.isBlank((CharSequence)s)) {
                                Mapton.getLog().v("Open location", s);
                                SystemHelper.desktopBrowse((String)s);
                            }
                        });
                        continue block5;
                    }
                }
                throw new AssertionError();
            }
            this.mContextCopyMenu.getItems().sorted((o1, o2) -> o1.getText().compareToIgnoreCase(o2.getText()));
            this.mContextCopyMenu.setVisible(!this.mContextCopyMenu.getItems().isEmpty());
            this.mContextOpenMenu.getItems().sorted((o1, o2) -> o1.getText().compareToIgnoreCase(o2.getText()));
            this.mContextOpenMenu.setVisible(!this.mContextOpenMenu.getItems().isEmpty());
            this.mContextExtrasMenu.getItems().sorted((o1, o2) -> o1.getText().compareToIgnoreCase(o2.getText()));
            this.mContextExtrasMenu.setVisible(!this.mContextExtrasMenu.getItems().isEmpty());
        });
    }

    private void whatsHere() {
        Mapton.getGlobalState().put("Status.Progress", (Object)-1.0);
        new Thread(() -> {
            ArrayList engines = new ArrayList(Lookup.getDefault().lookupAll(MWhatsHereEngine.class));
            if (!engines.isEmpty()) {
                MWhatsHereEngine whatsHereEngine = (MWhatsHereEngine)engines.get(0);
                int zoom = (int)(5.0 + this.getEngine().getZoom() * 18.0);
                String s = whatsHereEngine.getResult(this.getEngine().getLatLonMouse(), zoom);
                if (StringUtils.isNotBlank((CharSequence)s)) {
                    Mapton.notification((String)"toolbar.notification.information", (String)this.getBundleString("whats_here"), (String)s);
                    Mapton.execute(() -> this.getEngine().onWhatsHere(s));
                }
                Mapton.getGlobalState().put("Status.Progress", (Object)1.0);
            }
        }, this.getClass().getCanonicalName()).start();
    }
}

