/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.controlsfx.control.PropertySheet;
import org.mapton.api.MPropertyItem;
import org.mapton.api.MSelectionLockManager;
import org.mapton.api.Mapton;
import org.mapton.core.api.MTopComponent;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.control.LogPanel;
import se.trixon.almond.util.icons.material.MaterialIcon;

@TopComponent.Description(preferredID="PropertiesTopComponent", persistenceType=0)
public final class PropertiesTopComponent
extends MTopComponent {
    public PropertiesTopComponent() {
        this.setName(Dict.PROPERTIES.toString());
        this.putClientProperty("print.printable", Boolean.TRUE);
        this.putClientProperty("print.name", "Mapton - %s".formatted(Dict.PROPERTIES.toString()));
    }

    @Override
    protected void initFX() {
        this.setScene(new Scene((Parent)new PropertiesView()));
        Mapton.getGlobalState().put("object.properties", Mapton.getGlobalState().get("object.properties"));
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    class PropertiesView
    extends BorderPane {
        private final Map<String, Object> mDummyMap = new LinkedHashMap<String, Object>();
        private LogPanel mLogPanel;
        private Label mPlaceholderLabel;
        private PropertySheet mPropertySheet;

        public PropertiesView() {
            this.createUI();
            this.initListeners();
            this.refresh(null);
        }

        private void createUI() {
            this.mPropertySheet = new PropertySheet();
            this.mPropertySheet.setMode(PropertySheet.Mode.NAME);
            this.mLogPanel = new LogPanel();
            this.setCenter((Node)this.mPropertySheet);
            this.mPlaceholderLabel = new Label(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"object_properties_placeholder"), (Node)MaterialIcon._Action.ASSIGNMENT.getImageView(Mapton.getIconSizeToolBar()));
            this.mPlaceholderLabel.setDisable(true);
        }

        private void initListeners() {
            Mapton.getGlobalState().addListener(evt -> Platform.runLater(() -> this.refresh(evt.getValue())), new String[]{"object.properties"});
        }

        private void load(String text) {
            this.mLogPanel.setText(text);
        }

        private void loadList(ObservableList<PropertySheet.Item> propertyItems) {
            this.mPropertySheet.getItems().setAll(propertyItems);
        }

        private void loadMap(Map<String, Object> propertiesMap) {
            ObservableList propertyItems = FXCollections.observableArrayList();
            propertiesMap.keySet().forEach(key -> propertyItems.add((Object)new MPropertyItem(propertiesMap, key)));
            this.loadList((ObservableList<PropertySheet.Item>)propertyItems);
        }

        private void refresh(Object o) {
            if (MSelectionLockManager.getInstance().isLocked()) {
                return;
            }
            Label centerObject = null;
            if (o == null) {
                centerObject = this.mPlaceholderLabel;
            } else if (o.getClass().isInstance(this.mPropertySheet.getItems())) {
                centerObject = this.mPropertySheet;
                this.loadList((ObservableList<PropertySheet.Item>)((ObservableList)o));
            } else if (o.getClass().isInstance(this.mDummyMap)) {
                centerObject = this.mPropertySheet;
                this.loadMap((Map)o);
            } else if (o instanceof Node) {
                Node node = (Node)o;
                centerObject = node;
            } else if (o instanceof String) {
                String s = (String)o;
                centerObject = this.mLogPanel;
                this.load(s);
            } else {
                centerObject = this.mLogPanel;
                this.load(ToStringBuilder.reflectionToString((Object)o, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
            }
            this.setCenter((Node)centerObject);
        }
    }
}

