/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.beforeafter;

import com.dlsc.gemsfx.BeforeAfterView;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.Properties;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import org.mapton.api.Mapton;
import org.mapton.core.api.MTopComponent;
import org.mapton.core.ui.beforeafter.Bundle;
import org.openide.awt.Actions;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="BeforeAfterTopComponent", persistenceType=0)
public final class BeforeAfterTopComponent
extends MTopComponent {
    private BeforeAfterView mBeforeAfterView;

    public BeforeAfterTopComponent() {
        String name = Actions.cutAmpersand((String)Bundle.CTL_BeforeAfterAction());
        this.setName(name);
        this.putClientProperty("print.printable", Boolean.TRUE);
        this.putClientProperty("print.name", "Mapton - %s".formatted(name));
    }

    @Override
    protected void initFX() {
        this.mBeforeAfterView = new BeforeAfterView();
        this.mBeforeAfterView.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Scene scene = new Scene((Parent)this.mBeforeAfterView);
        this.setScene(scene);
        scene.setOnDragOver(dragEvent -> {
            Dragboard board = dragEvent.getDragboard();
            if (board.hasFiles()) {
                dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            }
        });
        this.getScene().setOnDragDropped(dragEvent -> this.refresh(dragEvent.getDragboard().getFiles()));
        Mapton.getGlobalState().addListener(gsce -> Platform.runLater(() -> this.refresh(gsce.getValue())), new String[]{"before_after_image"});
        Mapton.getGlobalState().put("before_after_image", Mapton.getGlobalState().get("before_after_image"));
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    private void refresh(Object o) {
        if (o instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)o;
            this.mBeforeAfterView.setAfter(this.mBeforeAfterView.getBefore());
            this.mBeforeAfterView.setBefore((Node)new ImageView((Image)SwingFXUtils.toFXImage((BufferedImage)bi, null)));
        } else if (o instanceof List) {
            List files = (List)o;
            if (files.size() > 1) {
                this.mBeforeAfterView.setAfter((Node)new ImageView(((File)files.get(1)).getAbsolutePath()));
                this.mBeforeAfterView.setBefore((Node)new ImageView(((File)files.get(0)).getAbsolutePath()));
            } else {
                this.mBeforeAfterView.setAfter(this.mBeforeAfterView.getBefore());
                this.mBeforeAfterView.setBefore((Node)new ImageView(((File)files.get(0)).getAbsolutePath()));
            }
        }
    }
}

