/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.bookmark;

import java.util.Collection;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.mapton.api.MBookmarkManager;
import se.trixon.almond.nbp.fx.FxDialogPanel;
import se.trixon.almond.util.Dict;

public class CategoryPanel
extends FxDialogPanel {
    private CategoryView mCategoryView;

    public String getCategory() {
        return this.mCategoryView.getCategory();
    }

    public void setCategory(String category) {
        this.mCategoryView.setCategory(category);
    }

    @Override
    protected void fxConstructor() {
        this.mCategoryView = new CategoryView();
        this.setScene(new Scene((Parent)this.mCategoryView));
    }

    class CategoryView
    extends StackPane {
        private ComboBox<String> mCategoryComboBox;
        private MBookmarkManager mManager = MBookmarkManager.getInstance();

        public CategoryView() {
            this.createUI();
        }

        public String getCategory() {
            return (String)this.mCategoryComboBox.getSelectionModel().getSelectedItem();
        }

        public void setCategory(String category) {
            this.mCategoryComboBox.getSelectionModel().select((Object)category);
        }

        private void createUI() {
            Label label = new Label(Dict.CATEGORY.toString());
            this.mCategoryComboBox = new ComboBox();
            this.mCategoryComboBox.getItems().setAll((Collection)this.mManager.getCategories());
            this.mCategoryComboBox.setEditable(true);
            VBox box = new VBox(new Node[]{label, this.mCategoryComboBox});
            box.setPadding(new Insets(8.0, 16.0, 0.0, 16.0));
            this.mCategoryComboBox.prefWidthProperty().bind((ObservableValue)box.widthProperty());
            Insets topInsets = new Insets(8.0, 0.0, 8.0, 0.0);
            VBox.setMargin((Node)label, (Insets)topInsets);
            this.getChildren().setAll((Object[])new Node[]{box});
        }
    }
}

