/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.file_drop_switchboard;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.apache.commons.lang3.StringUtils;
import org.mapton.api.MCooTrans;
import org.mapton.api.MCoordinateFileInput;
import org.mapton.api.MCoordinateFileOpener;
import org.mapton.api.MCrsManager;
import org.mapton.api.MOptions;
import org.mapton.core.ui.file_drop_switchboard.FileDropSwitchboardView;
import org.mapton.core.ui.file_drop_switchboard.FileOpenerItemListCell;
import org.mapton.core.ui.file_drop_switchboard.FileOpenerListCell;
import org.openide.util.NbBundle;
import se.trixon.almond.util.fx.FxHelper;

public class ExtTab
extends Tab {
    private final ResourceBundle mBundle;
    private final ComboBox<MCooTrans> mCooTransComboBox = new ComboBox();
    private final ComboBox<MCoordinateFileOpener> mCoordinateFileOpenerComboBox = new ComboBox();
    private final ArrayList<MCoordinateFileOpener> mCoordinateFileOpeners;
    private final ListView<MCoordinateFileInput> mListView = new ListView();
    private final BorderPane mRoot = new BorderPane();
    private final String mExt;

    ExtTab(String ext, ArrayList<File> files, ArrayList<MCoordinateFileOpener> coordinateFileOpeners) {
        this.mExt = ext;
        this.mBundle = NbBundle.getBundle(FileDropSwitchboardView.class);
        this.mCoordinateFileOpeners = coordinateFileOpeners;
        this.createUI();
        this.initListeners();
        this.setText(this.mExt);
        files.stream().sorted(File::compareTo).forEachOrdered(file -> this.mListView.getItems().add((Object)new MCoordinateFileInput(coordinateFileOpeners, file)));
    }

    ObservableList<MCoordinateFileInput> getItems() {
        return this.mListView.getItems();
    }

    private void createUI() {
        this.setClosable(false);
        this.mCoordinateFileOpenerComboBox.getItems().setAll(this.mCoordinateFileOpeners);
        this.mCoordinateFileOpenerComboBox.setCellFactory(k -> new FileOpenerListCell());
        this.mCoordinateFileOpenerComboBox.setButtonCell((ListCell)new FileOpenerListCell());
        this.mCoordinateFileOpenerComboBox.getSelectionModel().select(0);
        this.mCooTransComboBox.getItems().setAll((Collection)MCrsManager.getInstance().getItems());
        this.mCooTransComboBox.setItems((ObservableList)this.mCooTransComboBox.getItems().sorted());
        this.mCooTransComboBox.getSelectionModel().select((Object)MOptions.getInstance().getMapCooTrans());
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)this.mExt, (CharSequence[])new CharSequence[]{"grid", "kml", "kmz"})) {
            this.mCooTransComboBox.setValue((Object)MCooTrans.getCooTrans((String)"WGS 84"));
            this.mCooTransComboBox.setDisable(true);
        }
        HBox headerBox = new HBox((double)FxHelper.getUIScaled((int)8));
        headerBox.setPadding(FxHelper.getUIScaledInsets((double)8.0));
        headerBox.getChildren().addAll((Object[])new Node[]{new VBox(new Node[]{new Label(this.mBundle.getString("default_openers")), this.mCoordinateFileOpenerComboBox}), new VBox(new Node[]{new Label(this.mBundle.getString("default_coosys")), this.mCooTransComboBox})});
        this.mListView.setCellFactory(listview -> new FileOpenerItemListCell(this.mExt, this.mCoordinateFileOpeners));
        this.mRoot.setTop((Node)headerBox);
        this.mRoot.setCenter(this.mListView);
        this.setContent((Node)this.mRoot);
    }

    private void initListeners() {
        this.mCoordinateFileOpenerComboBox.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mListView.getItems().forEach(item -> item.setCoordinateFileOpener(newValue));
            this.mListView.refresh();
        });
        this.mCooTransComboBox.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mListView.getItems().forEach(item -> item.setCooTrans(newValue));
            this.mListView.refresh();
        });
    }
}

