/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.file_drop_switchboard;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.BorderPane;
import org.apache.commons.io.FilenameUtils;
import org.mapton.api.MCoordinateFile;
import org.mapton.api.MCoordinateFileOpener;
import org.mapton.api.Mapton;
import org.mapton.core.ui.file_drop_switchboard.ExtTab;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FileDropSwitchboardView
extends BorderPane {
    private final ResourceBundle mBundle;
    private final List<File> mFiles;
    private final TabPane mTabPane = new TabPane();

    public FileDropSwitchboardView(List<File> files) {
        this.mFiles = files;
        this.mBundle = NbBundle.getBundle(FileDropSwitchboardView.class);
        this.createUI();
    }

    public boolean hasFiles() {
        return this.mTabPane.getTabs().stream().anyMatch(tab -> tab instanceof ExtTab);
    }

    public void openFiles() {
        HashMap coordinateFileOpenerToCoordinateFiles = new HashMap();
        this.mTabPane.getTabs().stream().filter(tab -> tab instanceof ExtTab).forEachOrdered(tab -> ((ExtTab)((Object)tab)).getItems().forEach(coordinateFileInput -> {
            MCoordinateFileOpener coordinateFileOpener = coordinateFileInput.getCoordinateFileOpener();
            MCoordinateFile coordinateFile = new MCoordinateFile();
            coordinateFile.setFile(coordinateFileInput.getFile());
            coordinateFile.setCooTrans(coordinateFileInput.getCooTrans());
            coordinateFile.setCoordinateFileOpenerName(coordinateFileOpener.getClass().getName());
            coordinateFileOpenerToCoordinateFiles.computeIfAbsent(coordinateFileOpener, k -> new ArrayList()).add(coordinateFile);
        }));
        coordinateFileOpenerToCoordinateFiles.entrySet().forEach(entry -> Mapton.getGlobalState().put(((MCoordinateFileOpener)entry.getKey()).getClass().getName(), entry.getValue()));
    }

    private void createUI() {
        this.setCenter((Node)this.mTabPane);
        TreeMap extToCoordinateFileOpeners = new TreeMap();
        Lookup.getDefault().lookupAll(MCoordinateFileOpener.class).forEach(coordinateFileOpener -> {
            for (String extension : coordinateFileOpener.getExtensions()) {
                extToCoordinateFileOpeners.computeIfAbsent(extension.toLowerCase(Locale.getDefault()), k -> new ArrayList()).add(coordinateFileOpener);
            }
        });
        extToCoordinateFileOpeners.values().forEach(coordinateFileOpener -> coordinateFileOpener.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName())));
        TreeMap extToFiles = new TreeMap();
        ListView listView = new ListView();
        this.mFiles.forEach(file -> {
            String extension = FilenameUtils.getExtension((String)file.getName()).toLowerCase(Locale.getDefault());
            if (extToCoordinateFileOpeners.containsKey(extension)) {
                extToFiles.computeIfAbsent(extension, k -> new ArrayList()).add(file);
            } else {
                listView.getItems().add(file);
            }
        });
        extToFiles.entrySet().stream().map(entry -> new ExtTab((String)entry.getKey(), (ArrayList)entry.getValue(), (ArrayList)extToCoordinateFileOpeners.get(entry.getKey()))).forEachOrdered(extTab -> this.mTabPane.getTabs().add((Object)extTab));
        if (!listView.getItems().isEmpty()) {
            listView.getItems().sort(File::compareTo);
            Tab tab = new Tab(this.mBundle.getString("unassociated"), (Node)listView);
            tab.setClosable(false);
            this.mTabPane.getTabs().add((Object)tab);
        }
    }
}

