/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.file_drop_switchboard;

import java.util.ArrayList;
import java.util.Collection;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.layout.HBox;
import org.apache.commons.lang3.StringUtils;
import org.mapton.api.MCooTrans;
import org.mapton.api.MCoordinateFileInput;
import org.mapton.api.MCoordinateFileOpener;
import org.mapton.api.MCrsManager;
import org.mapton.core.ui.file_drop_switchboard.FileOpenerListCell;
import se.trixon.almond.util.fx.FxHelper;

class FileOpenerItemListCell
extends ListCell<MCoordinateFileInput> {
    private HBox mBox;
    private ComboBox<MCooTrans> mCooTransComboBox;
    private final String mExt;
    private ComboBox<MCoordinateFileOpener> mCoordinateFileOpenerComboBox;
    private final ArrayList<MCoordinateFileOpener> mCoordinateFileOpeners;
    private MCoordinateFileInput mItem;

    public FileOpenerItemListCell(String ext, ArrayList<MCoordinateFileOpener> coordinateFileOpeners) {
        this.mExt = ext;
        this.mCoordinateFileOpeners = coordinateFileOpeners;
        this.createUI();
    }

    protected void updateItem(MCoordinateFileInput item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item == null || empty) {
            this.clearContent();
        } else {
            this.addContent(item);
        }
    }

    private void addContent(MCoordinateFileInput item) {
        this.mItem = item;
        this.mCoordinateFileOpenerComboBox.setValue((Object)item.getCoordinateFileOpener());
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)this.mExt, (CharSequence[])new CharSequence[]{"grid", "kml", "kmz"})) {
            this.mCooTransComboBox.setValue((Object)MCooTrans.getCooTrans((String)"WGS 84"));
        } else {
            this.mCooTransComboBox.setValue((Object)item.getCooTrans());
        }
        this.setGraphic((Node)this.mBox);
        this.setText(item.getFile().getName());
    }

    private void clearContent() {
        this.setText(null);
        this.setGraphic(null);
    }

    private void createUI() {
        this.mCoordinateFileOpenerComboBox = new ComboBox();
        this.mCoordinateFileOpenerComboBox.getItems().setAll(this.mCoordinateFileOpeners);
        this.mCoordinateFileOpenerComboBox.setCellFactory(k -> new FileOpenerListCell());
        this.mCoordinateFileOpenerComboBox.setButtonCell((ListCell)new FileOpenerListCell());
        this.mCoordinateFileOpenerComboBox.setOnAction(ae -> {
            MCoordinateFileOpener fileOpener = (MCoordinateFileOpener)this.mCoordinateFileOpenerComboBox.valueProperty().get();
            if (fileOpener != null) {
                this.mItem.setCoordinateFileOpener(fileOpener);
            }
        });
        this.mCooTransComboBox = new ComboBox();
        this.mCooTransComboBox.getItems().setAll((Collection)MCrsManager.getInstance().getItems());
        this.mCooTransComboBox.setItems((ObservableList)this.mCooTransComboBox.getItems().sorted());
        this.mCooTransComboBox.setOnAction(ae -> {
            MCooTrans cooTrans = (MCooTrans)this.mCooTransComboBox.valueProperty().get();
            if (cooTrans != null) {
                this.mItem.setCooTrans(cooTrans);
            }
        });
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)this.mExt, (CharSequence[])new CharSequence[]{"grid", "kml", "kmz"})) {
            this.mCooTransComboBox.setDisable(true);
        }
        this.mBox = new HBox((double)FxHelper.getUIScaled((int)8), new Node[]{this.mCoordinateFileOpenerComboBox, this.mCooTransComboBox});
        this.mBox.setPadding(FxHelper.getUIScaledInsets((double)0.0, (double)12.0, (double)0.0, (double)0.0));
    }
}

