/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.grid;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.controlsfx.control.action.Action;
import org.mapton.api.FileChooserHelper;
import org.mapton.api.MNotificationIcons;
import org.mapton.api.Mapton;
import org.mapton.core.ui.grid.FileAction;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Exceptions;
import se.trixon.almond.nbp.Almond;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxActionSwing;
import se.trixon.almond.util.icons.material.MaterialIcon;
import se.trixon.almond.util.swing.FileHelper;

public class FileExportAction
extends FileAction {
    @Override
    public Action getAction(Node owner) {
        FxActionSwing action = new FxActionSwing(Dict.EXPORT.toString(), () -> {
            ArrayList selectedGrids = this.mManager.getItems().stream().filter(grid -> grid.isVisible()).collect(Collectors.toCollection(ArrayList::new));
            if (!selectedGrids.isEmpty()) {
                String dialogTitle = "%s %s".formatted(Dict.EXPORT.toString(), this.mTitle.toLowerCase());
                HashMap extensionFilters = FileChooserHelper.getExtensionFilters();
                JFileChooser fileChooser = new FileChooserBuilder(FileExportAction.class).addFileFilter((FileFilter)extensionFilters.get("grid")).setAcceptAllFileFilterUsed(false).setDefaultWorkingDirectory(FileHelper.getDefaultDirectory()).setFileFilter((FileFilter)extensionFilters.get("grid")).setFilesOnly(true).setSelectionApprover(FileChooserHelper.getFileExistSelectionApprover((Component)Almond.getFrame())).setTitle(dialogTitle).createFileChooser();
                if (fileChooser.showSaveDialog(Almond.getFrame()) == 0) {
                    new Thread(() -> {
                        File file = FileChooserHelper.getFileWithProperExt((JFileChooser)fileChooser);
                        try {
                            this.mManager.gridExport(file, selectedGrids);
                            NotificationDisplayer.getDefault().notify(Dict.OPERATION_COMPLETED.toString(), (Icon)MNotificationIcons.getInformationIcon(), dialogTitle, null, NotificationDisplayer.Priority.LOW);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }, this.getClass().getCanonicalName()).start();
                }
            }
        });
        action.setGraphic((Node)MaterialIcon._Content.SAVE.getImageView(Mapton.getIconSizeToolBarInt()));
        return action;
    }
}

