/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.grid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ToolBar;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import org.controlsfx.control.CheckListView;
import org.controlsfx.control.IndexedCheckModel;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.mapton.api.MLocalGrid;
import org.mapton.api.MLocalGridManager;
import org.mapton.api.MOptions;
import org.mapton.api.Mapton;
import org.mapton.core.ui.grid.FileExportAction;
import org.mapton.core.ui.grid.FileImportAction;
import org.mapton.core.ui.grid.LocalGridEditor;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.icons.material.MaterialIcon;

public class LocalGridsView
extends BorderPane {
    private final CheckListView<MLocalGrid> mListView = new CheckListView();
    private final LocalGridEditor mLocalGridEditor;
    private final MLocalGridManager mManager = MLocalGridManager.getInstance();
    private final MOptions mOptions = MOptions.getInstance();
    private CheckBox mPlotCheckBox;

    public LocalGridsView() {
        this.mLocalGridEditor = new LocalGridEditor();
        this.createUI();
        this.initStates();
        this.initListeners();
        this.load();
    }

    private void createUI() {
        this.mPlotCheckBox = new CheckBox(Dict.LOCAL.toString());
        this.mPlotCheckBox.setStyle("-fx-font-weight: bold; -fx-font-size: 1.3em");
        this.mPlotCheckBox.setPadding(new Insets(0.0, 0.0, 0.0, 8.0));
        Action addAction = new Action(Dict.ADD.toString(), actionEvent -> this.mLocalGridEditor.edit(null));
        addAction.setGraphic((Node)MaterialIcon._Content.ADD.getImageView(Mapton.getIconSizeToolBarInt()));
        Action editAction = new Action(Dict.EDIT.toString(), actionEvent -> {
            if (this.getSelected() != null) {
                this.mLocalGridEditor.edit(this.getSelected());
            }
        });
        editAction.setGraphic((Node)MaterialIcon._Editor.MODE_EDIT.getImageView(Mapton.getIconSizeToolBarInt()));
        Action remAction = new Action(Dict.REMOVE.toString(), actionEvent -> {
            if (this.getSelected() != null) {
                this.mLocalGridEditor.remove(this.getSelected());
            }
        });
        remAction.setGraphic((Node)MaterialIcon._Content.REMOVE.getImageView(Mapton.getIconSizeToolBarInt()));
        List<Action> actions = Arrays.asList(new FileImportAction().getAction((Node)this), new FileExportAction().getAction((Node)this), addAction, remAction, editAction);
        ToolBar toolBar = ActionUtils.createToolBar(actions, (ActionUtils.ActionTextBehavior)ActionUtils.ActionTextBehavior.HIDE);
        FxHelper.adjustButtonWidth((Stream)toolBar.getItems().stream(), (double)Mapton.getIconSizeToolBarInt());
        toolBar.getItems().stream().filter(item -> item instanceof ButtonBase).map(item -> (ButtonBase)item).forEachOrdered(buttonBase -> FxHelper.undecorateButton((ButtonBase)buttonBase));
        FxHelper.slimToolBar((ToolBar)toolBar);
        this.setTop((Node)new VBox(8.0, new Node[]{this.mPlotCheckBox, toolBar}));
        this.setCenter((Node)this.mListView);
        toolBar.disableProperty().bind((ObservableValue)this.mPlotCheckBox.selectedProperty().not());
        this.mListView.disableProperty().bind((ObservableValue)this.mPlotCheckBox.selectedProperty().not());
        this.mListView.setPrefHeight(FxHelper.getUIScaled((double)150.0));
        this.mListView.setItems(this.mManager.getItems());
    }

    private MLocalGrid getSelected() {
        return (MLocalGrid)this.mListView.getSelectionModel().getSelectedItem();
    }

    private void initListeners() {
        this.mPlotCheckBox.setOnAction(event -> this.mOptions.put("grid.local.plot", this.mPlotCheckBox.isSelected()));
        this.mListView.setOnMouseClicked(mouseEvent -> {
            if (this.getSelected() != null && mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() == 2) {
                this.getSelected().fitToBounds();
            }
        });
        this.mManager.getItems().addListener(c -> Platform.runLater(() -> {
            this.refreshCheckedStates();
            this.mManager.save();
        }));
    }

    private void initStates() {
        this.mPlotCheckBox.setSelected(this.mOptions.is("grid.local.plot", new boolean[0]));
    }

    private void load() {
        ArrayList grids = this.mManager.loadItems();
        Platform.runLater(() -> {
            IndexedCheckModel checkModel = this.mListView.getCheckModel();
            ObservableList items = this.mListView.getItems();
            checkModel.getCheckedItems().addListener(c -> Platform.runLater(() -> {
                items.forEach(grid -> grid.setVisible(checkModel.isChecked(grid)));
                this.mManager.save();
            }));
            items.clear();
            if (grids != null) {
                items.addAll((Collection)grids);
                this.refreshCheckedStates();
            }
        });
    }

    private void refreshCheckedStates() {
        IndexedCheckModel checkModel = this.mListView.getCheckModel();
        ObservableList items = this.mListView.getItems();
        for (MLocalGrid grid : items) {
            if (grid.isVisible()) {
                checkModel.check((Object)grid);
                continue;
            }
            checkModel.clearCheck((Object)grid);
        }
    }
}

